/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.IntStream;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.PrimitiveVector;
import smile.util.Index;

public class ByteVector
extends PrimitiveVector {
    private final byte[] vector;

    public ByteVector(String name, byte[] vector) {
        this(new StructField(name, DataTypes.ByteType), vector);
    }

    public ByteVector(StructField field, byte[] vector) {
        if (field.dtype() != DataTypes.ByteType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        super(field);
        this.vector = vector;
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public ByteVector withName(String name) {
        return new ByteVector(this.field.withName(name), this.vector);
    }

    @Override
    public IntStream intStream() {
        return this.index().map(i -> this.vector[i]);
    }

    @Override
    public void set(int i, Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
        Number n = (Number)value;
        this.vector[i] = n.byteValue();
    }

    @Override
    public ByteVector get(Index index) {
        int n = index.size();
        byte[] data = new byte[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.vector[index.apply(i)];
        }
        return new ByteVector(this.field, data);
    }

    @Override
    public Byte get(int i) {
        return this.vector[i];
    }

    @Override
    public byte getByte(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector[i] != 0;
    }

    @Override
    public char getChar(int i) {
        return (char)this.vector[i];
    }

    @Override
    public short getShort(int i) {
        return this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return this.vector[i];
    }

    @Override
    public long getLong(int i) {
        return this.vector[i];
    }

    @Override
    public float getFloat(int i) {
        return this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }
}

