/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.AbstractGeometry;
import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.positions.SinglePosition;

public class Point
extends AbstractGeometry<SinglePosition> {
    private static final long serialVersionUID = 1L;

    public Point(SinglePosition positions) {
        super(positions);
    }

    public static Point from(double lon, double lat) {
        return Point.from(lon, lat, Double.NaN);
    }

    public static Point from(double lon, double lat, double alt) {
        return new Point(new SinglePosition(lon, lat, alt));
    }

    public double lon() {
        return ((SinglePosition)this.positions()).lon();
    }

    public double lat() {
        return ((SinglePosition)this.positions()).lat();
    }

    public double alt() {
        return ((SinglePosition)this.positions()).alt();
    }

    public Point withLon(double lon) {
        return Point.from(lon, this.lat(), this.alt());
    }

    public Point withLat(double lat) {
        return Point.from(this.lon(), lat, this.alt());
    }

    public Point withAlt(double alt) {
        return Point.from(this.lon(), this.lat(), alt);
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.POINT;
    }
}

