/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.AbstractGeometry;
import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.Polygon;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.MultiDimensionalPositions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiPolygon
extends AbstractGeometry<MultiDimensionalPositions> {
    private static final long serialVersionUID = 1L;

    public MultiPolygon(MultiDimensionalPositions positions) {
        super(positions);
    }

    public static MultiPolygon of(Polygon ... polygons) {
        return MultiPolygon.of(Arrays.asList(polygons));
    }

    public static MultiPolygon of(Iterable<Polygon> polygons) {
        MultiDimensionalPositions.Builder positionsBuilder = MultiDimensionalPositions.builder();
        for (Polygon polygon : polygons) {
            positionsBuilder.addAreaPosition((AreaPositions)polygon.positions());
        }
        return new MultiPolygon(positionsBuilder.build());
    }

    public static MultiPolygon of(Stream<Polygon> polygons) {
        return MultiPolygon.of(polygons.collect(Collectors.toList()));
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.MULTI_POLYGON;
    }

    public List<Polygon> polygons() {
        return ((MultiDimensionalPositions)this.positions()).children().stream().map(Polygon::new).collect(Collectors.toList());
    }
}

