/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LinearGeometry;
import com.github.filosganga.geogson.model.Point;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiPoint
extends LinearGeometry {
    private static final long serialVersionUID = 1L;

    public MultiPoint(LinearPositions coordinates) {
        super(coordinates);
    }

    public static MultiPoint of(Point ... points) {
        return MultiPoint.of(Arrays.asList(points));
    }

    public static MultiPoint of(Iterable<Point> points) {
        LinearPositions.Builder positionsBuilder = LinearPositions.builder();
        for (Point point : points) {
            positionsBuilder.addSinglePosition((SinglePosition)point.positions());
        }
        return new MultiPoint(positionsBuilder.build());
    }

    public static MultiPoint of(Stream<Point> points) {
        return MultiPoint.of(points.collect(Collectors.toList()));
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.MULTI_POINT;
    }
}

