/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LinearGeometry;
import com.github.filosganga.geogson.model.Point;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.github.filosganga.geogson.util.Preconditions;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LineString
extends LinearGeometry {
    private static final long serialVersionUID = 1L;

    public LineString(LinearPositions positions) {
        super(Preconditions.checkArgument(positions, toCheck -> toCheck.size() >= 2, "LineString must be composed by a minimum of 2 points."));
    }

    public static LineString of(Point ... points) {
        return LineString.of(Arrays.asList(points));
    }

    public static LineString of(Iterable<Point> points) {
        LinearPositions.Builder positionsBuilder = LinearPositions.builder();
        for (Point point : points) {
            positionsBuilder.addSinglePosition((SinglePosition)point.positions());
        }
        return new LineString(positionsBuilder.build());
    }

    public static LineString of(Stream<Point> points) {
        return LineString.of(points.collect(Collectors.toList()));
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.LINE_STRING;
    }

    public boolean isClosed() {
        return ((LinearPositions)this.positions()).isClosed();
    }
}

