/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Feature;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FeatureCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Feature> features;

    public FeatureCollection(List<Feature> features) {
        this.features = features;
    }

    public static FeatureCollection of(Feature ... features) {
        return new FeatureCollection(Arrays.asList(features));
    }

    public List<Feature> features() {
        return Collections.unmodifiableList(this.features);
    }

    public int size() {
        return this.features.size();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.features);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureCollection other = (FeatureCollection)obj;
        return Objects.equals(this.features, other.features);
    }

    public String toString() {
        return "FeatureCollection{features=" + this.features + '}';
    }
}

