/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.google.gson.JsonElement;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Feature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Geometry<?> geometry;
    private final Map<String, JsonElement> properties;
    private final String id;
    private transient Integer cachedHashCode = null;

    private Feature(Geometry<?> geometry, Map<String, JsonElement> properties, Optional<String> id) {
        this.geometry = geometry;
        this.properties = properties;
        this.id = id.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Feature feature) {
        return Feature.builder().withGeometry(feature.geometry).withProperties(feature.properties).withId(feature.id);
    }

    public static Feature of(Geometry<?> geometry) {
        return Feature.builder().withGeometry(geometry).build();
    }

    public Geometry<?> geometry() {
        return this.geometry;
    }

    public Map<String, JsonElement> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = Objects.hash(this.getClass(), this.id, this.geometry, this.properties);
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.properties, other.properties) && Objects.equals(this.geometry, other.geometry);
    }

    public String toString() {
        return "Feature{geometry=" + this.geometry + ", properties=" + this.properties + ", id=" + this.id + '}';
    }

    public static class Builder {
        private Geometry<?> geometry = null;
        private Map<String, JsonElement> properties = new HashMap<String, JsonElement>(240);
        private Optional<String> id = Optional.empty();

        Builder() {
        }

        public Builder withGeometry(Geometry<?> geometry) {
            this.geometry = geometry;
            return this;
        }

        public Builder withProperties(Map<String, JsonElement> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public Builder withProperty(String name, JsonElement value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder withId(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder withId(String id) {
            return this.withId(Optional.of(id));
        }

        public Feature build() {
            if (this.geometry == null) {
                throw new IllegalStateException("geometry is required to build a Feature");
            }
            return new Feature(this.geometry, this.properties, this.id);
        }
    }
}

