/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.gson;

import com.github.filosganga.geogson.model.positions.AbstractPositions;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class PositionsAdapter
extends TypeAdapter<Positions> {
    public void write(JsonWriter out, Positions value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.beginArray();
            if (value instanceof SinglePosition) {
                SinglePosition sp = (SinglePosition)value;
                out.value(sp.lon());
                out.value(sp.lat());
                if (!Double.isNaN(sp.alt())) {
                    out.value(sp.alt());
                }
            } else {
                for (Positions positions : value.children()) {
                    this.write(out, positions);
                }
            }
            out.endArray();
        }
    }

    public Positions read(JsonReader in) throws IOException {
        Positions parsed;
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            parsed = null;
        } else if (peek == JsonToken.BEGIN_ARRAY) {
            parsed = PositionsAdapter.parsePositions(in);
        } else {
            throw new IllegalArgumentException("The json must be an array or null: " + in.peek());
        }
        return parsed;
    }

    private static Positions parsePositions(JsonReader in) throws IOException {
        Positions parsed = null;
        if (in.peek() != JsonToken.BEGIN_ARRAY) {
            throw new IllegalArgumentException("The given json is not a valid positions");
        }
        in.beginArray();
        if (in.peek() == JsonToken.NUMBER) {
            parsed = PositionsAdapter.parseSinglePosition(in);
        } else if (in.peek() == JsonToken.BEGIN_ARRAY) {
            AbstractPositions.PositionsBuilder builder = null;
            while (in.hasNext()) {
                Positions p = PositionsAdapter.parsePositions(in);
                if (builder == null) {
                    builder = AbstractPositions.PositionsBuilder.builderOf(p);
                }
                builder.addChild(p);
            }
            if (builder != null) {
                parsed = builder.build();
            }
        }
        in.endArray();
        return parsed;
    }

    private static Positions parseSinglePosition(JsonReader in) throws IOException {
        double lon = in.nextDouble();
        double lat = in.nextDouble();
        double alt = Double.NaN;
        if (in.hasNext()) {
            alt = in.nextDouble();
        }
        while (in.peek() != JsonToken.END_ARRAY) {
            in.skipValue();
        }
        return new SinglePosition(lon, lat, alt);
    }
}

