/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.extension.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static Logger log = Logger.getLogger(FileUtil.class.getName());
    public static final Pattern ADOC_FILE_EXTENSION = Pattern.compile("([^\\s]+(\\.(?i)(ad|adoc|asciidoc|asc))$)");

    public static File saveFile(String name, String data) {
        String fullyQualifiedName;
        if (name == null) {
            name = "";
        }
        if (!new File(fullyQualifiedName = name).isAbsolute()) {
            fullyQualifiedName = Paths.get("", new String[0]).toAbsolutePath().toString() + "/" + name;
        }
        try {
            if (fullyQualifiedName.contains("/")) {
                File f = new File(fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf("/")));
                f.mkdirs();
            }
            File file = new File(fullyQualifiedName);
            file.createNewFile();
            FileUtils.write((File)file, (CharSequence)data, (String)"UTF-8");
            log.info("Wrote: " + file.getAbsolutePath());
            return file;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not create file " + name, e);
            return null;
        }
    }

    public static File loadFile(String path) {
        File f;
        if (path == null) {
            path = "/";
        }
        if ((f = new File(path)).exists()) {
            return f.getAbsoluteFile();
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return new File(Paths.get("", new String[0]).toAbsolutePath().toString() + path.trim());
    }

    public static boolean removeFile(String path) {
        File fileToRemove = FileUtil.loadFile(path);
        return fileToRemove.delete();
    }

    public static File copyFile(String source, String dest) {
        if (source != null && dest != null) {
            try {
                InputStream in = FileUtil.class.getResourceAsStream(source);
                return FileUtil.saveFile(dest, IOUtils.toString((InputStream)in));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not copy source file: " + source + " to dest file: " + dest, e);
            }
        }
        return null;
    }

    public static List<String> findFiles(String startDir, String sulfix) {
        return FileUtil.findFiles(startDir, sulfix, false);
    }

    public static List<String> findFiles(String startDir, final String sulfix, final boolean singleResult) {
        Path startPath;
        final ArrayList<String> absolutePaths = new ArrayList<String>();
        if (startDir == null) {
            startDir = "";
        }
        if (!Files.exists(startPath = Paths.get(startDir, new String[0]), new LinkOption[0]) && startDir.startsWith("/")) {
            startDir = startDir.substring(1);
            startPath = Paths.get(startDir, new String[0]);
        }
        if (!Files.exists(startPath, new LinkOption[0])) {
            startPath = Paths.get("", new String[0]);
        }
        try {
            Files.walkFileTree(Paths.get(startDir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.endsWith(sulfix)) {
                        absolutePaths.add(file.toAbsolutePath().toString());
                        if (singleResult) {
                            return FileVisitResult.TERMINATE;
                        }
                    }
                    if (attrs.isDirectory()) {
                        return super.visitFile(file, attrs);
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Problems scanning " + sulfix + " files in path:" + startDir, e);
        }
        return absolutePaths;
    }

    public static File copyFileFromClassPath(String source, String dest) {
        if (source != null && dest != null) {
            try {
                InputStream in = FileUtil.class.getResourceAsStream(source);
                return FileUtil.saveFile(dest, IOUtils.toString((InputStream)in));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not copy source file: " + source + " to dest file: " + dest, e);
            }
        }
        return null;
    }

    public static String readFileContent(File target) {
        StringBuilder content = new StringBuilder();
        try (FileInputStream openStream = new FileInputStream(target);){
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(openStream));){
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    content.append(line);
                }
                bufferedReader.close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not read file content: " + target);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not read file content: " + target);
        }
        return content.toString();
    }

    public static File loadTestFile(String fileName) {
        return new File(Paths.get("", new String[0]).toAbsolutePath().toString() + "/target/test-classes/" + fileName);
    }

    public static String removeSpecialChars(String content) {
        return content.replaceAll(" ", "").replaceAll("\n", "").replaceAll("\t", "");
    }
}

