/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.renderer;

import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Step;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.renderer.CukedoctorExamplesRenderer;
import com.github.cukedoctor.renderer.CukedoctorStepsRenderer;
import com.github.cukedoctor.renderer.CukedoctorTagsRenderer;
import com.github.cukedoctor.spi.ExamplesRenderer;
import com.github.cukedoctor.spi.ScenarioRenderer;
import com.github.cukedoctor.spi.StepsRenderer;
import com.github.cukedoctor.spi.TagsRenderer;
import com.github.cukedoctor.util.Assert;
import java.util.List;
import java.util.ServiceLoader;

public class CukedoctorScenarioRenderer
extends AbstractBaseRenderer
implements ScenarioRenderer {
    TagsRenderer tagsRenderer;
    ExamplesRenderer examplesRenderer;
    StepsRenderer stepsRenderer;

    public CukedoctorScenarioRenderer() {
        this.loadDependentRenderers();
    }

    public CukedoctorScenarioRenderer(CukedoctorConfig cukedoctorConfig) {
        this.cukedoctorConfig = cukedoctorConfig;
        this.loadDependentRenderers();
    }

    private void loadDependentRenderers() {
        ServiceLoader<TagsRenderer> tagsRenderers = ServiceLoader.load(TagsRenderer.class);
        ServiceLoader<ExamplesRenderer> examplesRenderers = ServiceLoader.load(ExamplesRenderer.class);
        ServiceLoader<StepsRenderer> stepsRenderers = ServiceLoader.load(StepsRenderer.class);
        if (tagsRenderers.iterator().hasNext()) {
            this.tagsRenderer = tagsRenderers.iterator().next();
        } else {
            this.tagsRenderer = new CukedoctorTagsRenderer();
            this.tagsRenderer.setI18n(this.i18n);
        }
        if (examplesRenderers.iterator().hasNext()) {
            this.examplesRenderer = examplesRenderers.iterator().next();
        } else {
            this.examplesRenderer = new CukedoctorExamplesRenderer();
            this.examplesRenderer.setI18n(this.i18n);
        }
        if (stepsRenderers.iterator().hasNext()) {
            this.stepsRenderer = stepsRenderers.iterator().next();
        } else {
            this.stepsRenderer = new CukedoctorStepsRenderer();
            this.stepsRenderer.setI18n(this.i18n);
        }
    }

    @Override
    public String renderScenario(Scenario scenario, Feature feature) {
        this.docBuilder.clear();
        if (scenario.hasIgnoreDocsTag()) {
            return "";
        }
        if (scenario.isBackground() && feature.isBackgroundRendered()) {
            return "";
        }
        if (!feature.isBackgroundRendered() && scenario.isBackground()) {
            feature.setBackgroundRendered(true);
            StringBuilder backgroundTitle = new StringBuilder(scenario.getKeyword());
            if (!Status.passed.equals((Object)scenario.getStatus())) {
                backgroundTitle.append(" " + Status.getStatusIcon(Status.failed));
            }
            if (!this.cukedoctorConfig.isHideFeaturesSection().booleanValue()) {
                this.docBuilder.sectionTitleLevel3(backgroundTitle.toString().replaceAll("\\\\", ""));
            } else {
                this.docBuilder.sectionTitleLevel2(backgroundTitle.toString().replaceAll("\\\\", ""));
            }
        }
        if (Assert.hasText(scenario.getName())) {
            StringBuilder scenarioTitle = new StringBuilder();
            if (this.cukedoctorConfig.isHideScenarioKeyword().booleanValue()) {
                scenarioTitle.append(scenario.getName());
            } else {
                scenarioTitle.append(scenario.getKeyword()).append(": ").append(scenario.getName());
            }
            if (Assert.notNull((Object)scenario.getStatus()) && !Status.passed.equals((Object)scenario.getStatus())) {
                scenarioTitle.append(" " + Status.getStatusIcon(Status.failed));
            }
            if (!this.cukedoctorConfig.isHideFeaturesSection().booleanValue()) {
                this.docBuilder.sectionTitleLevel3(scenarioTitle.toString());
            } else {
                this.docBuilder.sectionTitleLevel2(scenarioTitle.toString());
            }
        }
        if (!this.cukedoctorConfig.isHideTags().booleanValue() && (feature.hasTags() || scenario.hasTags())) {
            this.docBuilder.append(this.renderScenarioTags(scenario, feature));
        }
        if (Assert.hasText(scenario.getDescription())) {
            this.docBuilder.textLine(scenario.getDescription().replaceAll("\\\\", "")).newLine();
        } else {
            this.docBuilder.textLine("").newLine();
        }
        if (scenario.hasExamples()) {
            this.docBuilder.append(this.renderScenarioExamples(scenario));
            return this.docBuilder.toString();
        }
        if (scenario.hasSteps()) {
            this.docBuilder.append(this.renderScenarioSteps(scenario.getSteps()));
        }
        return this.docBuilder.toString();
    }

    String renderScenarioSteps(List<Step> scenarioSteps) {
        return this.stepsRenderer.renderSteps(scenarioSteps);
    }

    String renderScenarioExamples(Scenario scenario) {
        return this.examplesRenderer.renderScenarioExamples(scenario);
    }

    String renderScenarioTags(Scenario scenario, Feature feature) {
        return this.tagsRenderer.renderScenarioTags(feature, scenario);
    }
}

