/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.renderer;

import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.renderer.CukedoctorScenarioRenderer;
import com.github.cukedoctor.spi.FeatureRenderer;
import com.github.cukedoctor.spi.ScenarioRenderer;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import java.util.List;
import java.util.ServiceLoader;

public class CukedoctorFeatureRenderer
extends AbstractBaseRenderer
implements FeatureRenderer {
    ScenarioRenderer scenarioRenderer;

    public CukedoctorFeatureRenderer() {
        this.loadDependentRenderers();
    }

    private void loadDependentRenderers() {
        ServiceLoader<ScenarioRenderer> scenarioRenderers = ServiceLoader.load(ScenarioRenderer.class);
        if (scenarioRenderers.iterator().hasNext()) {
            this.scenarioRenderer = scenarioRenderers.iterator().next();
        } else {
            this.scenarioRenderer = new CukedoctorScenarioRenderer();
            this.scenarioRenderer.setI18n(this.i18n);
        }
    }

    public CukedoctorFeatureRenderer(CukedoctorConfig cukedoctorConfig) {
        this.cukedoctorConfig = cukedoctorConfig;
        this.loadDependentRenderers();
    }

    @Override
    public String renderFeature(Feature feature) {
        String backend;
        this.docBuilder.clear();
        if (feature.hasIgnoreDocsTag()) {
            return "";
        }
        this.docBuilder.textLine(this.renderFeatureSectionId(feature));
        if (!this.cukedoctorConfig.isHideFeaturesSection().booleanValue()) {
            this.docBuilder.sectionTitleLevel2(Constants.Markup.bold(feature.getName())).newLine();
        } else {
            this.docBuilder.sectionTitleLevel1(Constants.Markup.bold(feature.getName())).newLine();
        }
        if (Assert.notNull(this.documentAttributes) && Assert.hasText(this.documentAttributes.getBackend()) && ((backend = this.documentAttributes.getBackend()).toLowerCase().contains("html") || backend.toLowerCase().contains("all")) && !this.cukedoctorConfig.isDisableMinMaxExtension().booleanValue()) {
            this.docBuilder.append("ifndef::backend-pdf[]").append(Constants.newLine());
            this.docBuilder.append("minmax::", feature.getName().replaceAll(",", "").replaceAll(" ", "-")).append("[]").newLine();
            this.docBuilder.append("endif::[]").append(Constants.newLine());
        }
        if (Assert.hasText(feature.getDescription())) {
            this.docBuilder.sideBarBlock(feature.getDescription().trim().replaceAll("\\\\", "").replaceAll("\\n", Constants.newLine()));
        }
        if (feature.hasScenarios()) {
            this.docBuilder.append(this.renderFeatureScenarios(feature));
        }
        return this.docBuilder.toString();
    }

    @Override
    public String renderFeatures(List<Feature> features) {
        CukedoctorDocumentBuilder parentBuilder = CukedoctorDocumentBuilder.Factory.newInstance();
        if (!this.cukedoctorConfig.isHideFeaturesSection().booleanValue()) {
            parentBuilder.sectionTitleLevel1(Constants.Markup.bold(this.i18n.getMessage("title.features"))).newLine();
        }
        for (Feature feature : features) {
            parentBuilder.append(this.renderFeature(feature));
        }
        return parentBuilder.toString();
    }

    protected String renderFeatureScenarios(Feature feature) {
        StringBuilder sb = new StringBuilder();
        for (Scenario scenario : feature.getScenarios()) {
            sb.append(this.renderFeatureScenario(scenario, feature));
        }
        feature.setBackgroundRendered(false);
        return sb.toString();
    }

    protected String renderFeatureSectionId(Feature feature) {
        if (Assert.isNull(feature) || Assert.not(Assert.hasText(feature.getName()))) {
            return "";
        }
        return "[[" + feature.getName().replaceAll(",", "").replaceAll(" ", "-") + ", " + feature.getName() + "]]";
    }

    protected String renderFeatureScenario(Scenario scenario, Feature feature) {
        return this.scenarioRenderer.renderScenario(scenario, feature);
    }
}

