/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.api.model;

import com.github.cukedoctor.api.model.Feature;
import java.util.List;

public class ScenarioTotalizations {
    private int totalPassedScenarios = 0;
    private int totalFailedScenarios = 0;
    private int totalScenarios = 0;
    private int totalPassedSteps = 0;
    private int totalFailedSteps = 0;
    private int totalSkippedSteps = 0;
    private int totalPendingSteps = 0;
    private int totalMissingSteps = 0;
    private int totalUndefinedSteps = 0;
    private int totalSteps = 0;
    private long totalDuration = 0L;

    public ScenarioTotalizations() {
    }

    public ScenarioTotalizations(List<Feature> features) {
        for (Feature feature : features) {
            this.addFeatureTotals(feature);
        }
    }

    public void addFeatureTotals(Feature feature) {
        this.totalPassedScenarios += feature.getScenarioResults().getNumberOfScenariosPassed().intValue();
        this.totalFailedScenarios += feature.getScenarioResults().getNumberOfScenariosFailed().intValue();
        this.totalScenarios += feature.getScenarioResults().getNumberOfScenarios().intValue();
        this.totalPassedSteps += feature.getStepResults().getNumberOfPasses();
        this.totalFailedSteps += feature.getStepResults().getNumberOfFailures();
        this.totalSkippedSteps += feature.getStepResults().getNumberOfSkipped();
        this.totalPendingSteps += feature.getStepResults().getNumberOfPending();
        this.totalMissingSteps += feature.getStepResults().getNumberOfMissing();
        this.totalUndefinedSteps += feature.getStepResults().getNumberOfUndefined();
        this.totalSteps += feature.getNumberOfSteps().intValue();
        this.totalDuration += feature.getStepResults().getTotalDuration();
    }

    public int getTotalPassedScenarios() {
        return this.totalPassedScenarios;
    }

    public int getTotalFailedScenarios() {
        return this.totalFailedScenarios;
    }

    public int getTotalScenarios() {
        return this.totalScenarios;
    }

    public int getTotalPassedSteps() {
        return this.totalPassedSteps;
    }

    public int getTotalFailedSteps() {
        return this.totalFailedSteps;
    }

    public int getTotalSkippedSteps() {
        return this.totalSkippedSteps;
    }

    public int getTotalPendingSteps() {
        return this.totalPendingSteps;
    }

    public int getTotalMissingSteps() {
        return this.totalMissingSteps;
    }

    public int getTotalUndefinedSteps() {
        return this.totalUndefinedSteps;
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }
}

