/*
 * Copyright 2016 Dmitry Avtonomov.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package umich.ms.fileio.filetypes.mzxml.jaxb;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;


/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType>
 *   &lt;simpleContent>
 *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema>anySimpleType">
 *       &lt;attribute name="first" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="last" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="phone" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="email">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;pattern value="(.)*[@](.)*\.(.)*"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="URI" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *     &lt;/extension>
 *   &lt;/simpleContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "value"
})
@XmlRootElement(name = "operator")
public class Operator {

  @XmlValue
  @XmlSchemaType(name = "anySimpleType")
  protected Object value;
  @XmlAttribute(name = "first", required = true)
  protected String first;
  @XmlAttribute(name = "last", required = true)
  protected String last;
  @XmlAttribute(name = "phone")
  protected String phone;
  @XmlAttribute(name = "email")
  protected String email;
  @XmlAttribute(name = "URI")
  @XmlSchemaType(name = "anyURI")
  protected String uri;

  /**
   * Gets the value of the value property.
   *
   * @return possible object is {@link Object }
   */
  public Object getValue() {
    return value;
  }

  /**
   * Sets the value of the value property.
   *
   * @param value allowed object is {@link Object }
   */
  public void setValue(Object value) {
    this.value = value;
  }

  /**
   * Gets the value of the first property.
   *
   * @return possible object is {@link String }
   */
  public String getFirst() {
    return first;
  }

  /**
   * Sets the value of the first property.
   *
   * @param value allowed object is {@link String }
   */
  public void setFirst(String value) {
    this.first = value;
  }

  /**
   * Gets the value of the last property.
   *
   * @return possible object is {@link String }
   */
  public String getLast() {
    return last;
  }

  /**
   * Sets the value of the last property.
   *
   * @param value allowed object is {@link String }
   */
  public void setLast(String value) {
    this.last = value;
  }

  /**
   * Gets the value of the phone property.
   *
   * @return possible object is {@link String }
   */
  public String getPhone() {
    return phone;
  }

  /**
   * Sets the value of the phone property.
   *
   * @param value allowed object is {@link String }
   */
  public void setPhone(String value) {
    this.phone = value;
  }

  /**
   * Gets the value of the email property.
   *
   * @return possible object is {@link String }
   */
  public String getEmail() {
    return email;
  }

  /**
   * Sets the value of the email property.
   *
   * @param value allowed object is {@link String }
   */
  public void setEmail(String value) {
    this.email = value;
  }

  /**
   * Gets the value of the uri property.
   *
   * @return possible object is {@link String }
   */
  public String getURI() {
    return uri;
  }

  /**
   * Sets the value of the uri property.
   *
   * @param value allowed object is {@link String }
   */
  public void setURI(String value) {
    this.uri = value;
  }

}
