package com.franciaflex.faxtomail.web.job;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: AbstractFaxToMailJob.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/job/AbstractFaxToMailJob.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.quartz.Job;
import org.quartz.JobExecutionContext;

import com.franciaflex.faxtomail.FaxToMailApplicationContext;

public abstract class AbstractFaxToMailJob implements Job {

    public static final String APPLICATION_CONTEXT = "applicationContext";

    protected FaxToMailApplicationContext getApplicationContext(JobExecutionContext jobExecutionContext) {
        FaxToMailApplicationContext applicationContext = (FaxToMailApplicationContext) jobExecutionContext.getMergedJobDataMap().get(APPLICATION_CONTEXT);
        return applicationContext;
    }
}
