package com.franciaflex.faxtomail.web.job;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: MailFilterJob.java 82 2014-05-20 14:25:32Z echatellier $
 * $HeadURL: https://svn.codelutin.com/faxtomail/trunk/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/MailFilterJob.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.EmailService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class EDIManagementJob extends AbstractFaxToMailJob {

    private static final Log log = LogFactory.getLog(EDIManagementJob.class);

    protected FaxToMailServiceContext serviceContext;

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        serviceContext = getServiceContext(jobExecutionContext);

        EmailService emailService = serviceContext.newService(EmailService.class);
        emailService.transmitPendingDemandsToEdi();

        //TODO kmorin 20140521 check in the transfert table if new command number arrived
    }

}
