/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import java.io.Serializable;

public class PropertyMetadata
implements Serializable {
    private static final long serialVersionUID = -1L;
    public static final PropertyMetadata STD_REQUIRED = new PropertyMetadata(Boolean.TRUE, null);
    public static final PropertyMetadata STD_OPTIONAL = new PropertyMetadata(Boolean.FALSE, null);
    public static final PropertyMetadata STD_REQUIRED_OR_OPTIONAL = new PropertyMetadata(null, null);
    protected final Boolean _required;
    protected final String _description;

    protected PropertyMetadata(Boolean bl, String string) {
        this._required = bl;
        this._description = string;
    }

    public static PropertyMetadata construct(boolean bl, String string) {
        PropertyMetadata propertyMetadata;
        PropertyMetadata propertyMetadata2 = propertyMetadata = bl ? STD_REQUIRED : STD_OPTIONAL;
        if (string != null) {
            return propertyMetadata.withDescription(string);
        }
        return propertyMetadata;
    }

    protected Object readResolve() {
        if (this._description == null) {
            if (this._required == null) {
                return STD_REQUIRED_OR_OPTIONAL;
            }
            return this._required != false ? STD_REQUIRED : STD_OPTIONAL;
        }
        return this;
    }

    public PropertyMetadata withDescription(String string) {
        return new PropertyMetadata(this._required, string);
    }

    public PropertyMetadata withRequired(Boolean bl) {
        if (bl == null ? this._required == null : this._required != null && this._required.booleanValue() == bl.booleanValue()) {
            return this;
        }
        return new PropertyMetadata(bl, this._description);
    }

    public String getDescription() {
        return this._description;
    }

    public boolean isRequired() {
        return this._required != null && this._required != false;
    }

    public Boolean getRequired() {
        return this._required;
    }
}

