/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.errorreporting;

import com.exasol.errorreporting.Quoting;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;

class Quoter {
    private Quoter() {
    }

    static String quoteObject(Object object, Quoting quoting) {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return "[" + collection.stream().map(item -> Quoter.quoteObject(item, quoting)).collect(Collectors.joining(", ")) + "]";
        }
        switch (quoting) {
            case SINGLE_QUOTES: {
                return "'" + object + "'";
            }
            case DOUBLE_QUOTES: {
                return "\"" + object + "\"";
            }
            case UNQUOTED: {
                return object.toString();
            }
        }
        if (object instanceof String || object instanceof Character || object instanceof Path || object instanceof File || object instanceof URL || object instanceof URI) {
            return "'" + object + "'";
        }
        return object.toString();
    }
}

