/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.errorreporting;

import com.exasol.errorreporting.ParameterDefinition;
import com.exasol.errorreporting.ParameterDefinitionList;
import com.exasol.errorreporting.ParametersMapper;
import com.exasol.errorreporting.PlaceholdersFiller;
import java.util.ArrayList;
import java.util.List;

public class ErrorMessageBuilder {
    private final String errorCode;
    private final StringBuilder messageBuilder = new StringBuilder();
    private final List<String> mitigations = new ArrayList<String>();
    private final ParameterDefinitionList parameterDefinitions = new ParameterDefinitionList();

    ErrorMessageBuilder(String errorCode) {
        this.errorCode = errorCode;
    }

    public ErrorMessageBuilder message(String message, Object ... arguments) {
        this.messageBuilder.append(message);
        this.addParameters(message, arguments);
        return this;
    }

    private void addParameters(String text, Object[] arguments) {
        Object[] patternArguments = this.getPatternArguments(arguments);
        ParametersMapper.mapParametersByName(text, patternArguments, this);
    }

    private Object[] getPatternArguments(Object[] arguments) {
        if (arguments == null) {
            return new Object[]{null};
        }
        return arguments;
    }

    public ErrorMessageBuilder parameter(String name, Object value) {
        this.parameterDefinitions.add(ParameterDefinition.builder(name).value(value).build());
        return this;
    }

    public ErrorMessageBuilder parameter(String placeholder, Object value, String ignoredDescription) {
        return this.parameter(placeholder, value);
    }

    public ErrorMessageBuilder mitigation(String mitigation, Object ... arguments) {
        this.mitigations.add(mitigation);
        this.addParameters(mitigation, arguments);
        return this;
    }

    public ErrorMessageBuilder ticketMitigation() {
        this.mitigation("This is an internal error that should not happen. Please report it by opening a GitHub issue.", new Object[0]);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.errorCode);
        if (this.messageBuilder.length() > 0) {
            result.append(": ");
            result.append(this.replacePlaceholders(this.messageBuilder.toString()));
        }
        if (this.mitigations.size() == 1) {
            result.append(" ");
            result.append(this.replacePlaceholders(this.mitigations.get(0)));
        } else if (this.mitigations.size() > 1) {
            result.append(" Known mitigations:");
            this.mitigations.forEach(mitigation -> {
                result.append("\n* ");
                result.append(this.replacePlaceholders((String)mitigation));
            });
        }
        return result.toString();
    }

    private String replacePlaceholders(String subject) {
        return PlaceholdersFiller.fillPlaceholders(subject, this.parameterDefinitions);
    }
}

