package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.*;
import jakarta.ws.rs.core.GenericType;

/** ConnectApi class. */
public class ConnectApi {
  private ApiClient apiClient;

  /** ConnectApi. */
  public ConnectApi() {
    this(Configuration.getDefaultApiClient());
  }

  /** ConnectApi. */
  public ConnectApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * getApiClient Method.
   *
   * @return ApiClient
   */
  public ApiClient getApiClient() {
    return apiClient;
  }

  /** setApiClient Method. */
  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Creates a connect configuration for the specified account.. Creates a DocuSign Custom Connect
   * definition for your account. DocuSign Connect enables the sending of real-time data updates to
   * external applications. These updates are generated by user transactions as the envelope
   * progresses through actions to completion. The Connect Service provides updated information
   * about the status of these transactions and returns updates that include the actual content of
   * document form fields. Be aware that, these updates might or might not include the document
   * itself. For more information about Connect, see the [ML:DocuSign Connect Service Guide]. ######
   * Note: Connect must be enabled for your account to use this function. This cannot be used to set
   * up Connect configurations for Salesforce or eOriginal.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectCustomConfiguration (optional)
   * @return ConnectCustomConfiguration
   * @throws ApiException if fails to make API call
   */
  public ConnectCustomConfiguration createConfiguration(
      String accountId, ConnectCustomConfiguration connectCustomConfiguration) throws ApiException {
    ApiResponse<ConnectCustomConfiguration> localVarResponse =
        createConfigurationWithHttpInfo(accountId, connectCustomConfiguration);
    return localVarResponse.getData();
  }

  /**
   * Creates a connect configuration for the specified account. Creates a DocuSign Custom Connect
   * definition for your account. DocuSign Connect enables the sending of real-time data updates to
   * external applications. These updates are generated by user transactions as the envelope
   * progresses through actions to completion. The Connect Service provides updated information
   * about the status of these transactions and returns updates that include the actual content of
   * document form fields. Be aware that, these updates might or might not include the document
   * itself. For more information about Connect, see the [ML:DocuSign Connect Service Guide]. ######
   * Note: Connect must be enabled for your account to use this function. This cannot be used to set
   * up Connect configurations for Salesforce or eOriginal.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectCustomConfiguration (optional)
   * @return ConnectCustomConfiguration
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectCustomConfiguration> createConfigurationWithHttpInfo(
      String accountId, ConnectCustomConfiguration connectCustomConfiguration) throws ApiException {
    Object localVarPostBody = connectCustomConfiguration;

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling createConfiguration");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectCustomConfiguration> localVarReturnType =
        new GenericType<ConnectCustomConfiguration>() {};
    ConnectCustomConfiguration localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "POST",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectCustomConfiguration>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Sets the Connect OAuth Config for the account..
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectOAuthConfig (optional)
   * @return ConnectOAuthConfig
   * @throws ApiException if fails to make API call
   */
  public ConnectOAuthConfig createConnectOAuthConfig(
      String accountId, ConnectOAuthConfig connectOAuthConfig) throws ApiException {
    ApiResponse<ConnectOAuthConfig> localVarResponse =
        createConnectOAuthConfigWithHttpInfo(accountId, connectOAuthConfig);
    return localVarResponse.getData();
  }

  /**
   * Sets the Connect OAuth Config for the account.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectOAuthConfig (optional)
   * @return ConnectOAuthConfig
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectOAuthConfig> createConnectOAuthConfigWithHttpInfo(
      String accountId, ConnectOAuthConfig connectOAuthConfig) throws ApiException {
    Object localVarPostBody = connectOAuthConfig;

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling createConnectOAuthConfig");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/oauth"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectOAuthConfig> localVarReturnType = new GenericType<ConnectOAuthConfig>() {};
    ConnectOAuthConfig localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "POST",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectOAuthConfig>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Deletes the specified connect configuration.. Deletes the specified DocuSign Connect
   * configuration. ###### Note: Connect must be enabled for your account to use this function.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteConfiguration(String accountId, String connectId) throws ApiException {
    deleteConfigurationWithHttpInfo(accountId, connectId);
  }

  /**
   * Deletes the specified connect configuration. Deletes the specified DocuSign Connect
   * configuration. ###### Note: Connect must be enabled for your account to use this function.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Object> deleteConfigurationWithHttpInfo(String accountId, String connectId)
      throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling deleteConfiguration");
    }

    // verify the required parameter 'connectId' is set
    if (connectId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'connectId' when calling deleteConfiguration");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/{connectId}"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "connectId" + "\\}", apiClient.escapeString(connectId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null);
    return new ApiResponse<Object>(apiClient.getStatusCode(), apiClient.getResponseHeaders(), null);
  }

  /**
   * Sets the Connect OAuth Config for the account..
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteConnectOAuthConfig(String accountId) throws ApiException {
    deleteConnectOAuthConfigWithHttpInfo(accountId);
  }

  /**
   * Sets the Connect OAuth Config for the account.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Object> deleteConnectOAuthConfigWithHttpInfo(String accountId)
      throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling deleteConnectOAuthConfig");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/oauth"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null);
    return new ApiResponse<Object>(apiClient.getStatusCode(), apiClient.getResponseHeaders(), null);
  }

  /**
   * Deletes a Connect failure log entry.. Deletes the Connect failure log information for the
   * specified entry.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param failureId The ID of the failed connect log entry. (required)
   * @return ConnectDeleteFailureResult
   * @throws ApiException if fails to make API call
   */
  public ConnectDeleteFailureResult deleteEventFailureLog(String accountId, String failureId)
      throws ApiException {
    ApiResponse<ConnectDeleteFailureResult> localVarResponse =
        deleteEventFailureLogWithHttpInfo(accountId, failureId);
    return localVarResponse.getData();
  }

  /**
   * Deletes a Connect failure log entry. Deletes the Connect failure log information for the
   * specified entry.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param failureId The ID of the failed connect log entry. (required)
   * @return ConnectDeleteFailureResult
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectDeleteFailureResult> deleteEventFailureLogWithHttpInfo(
      String accountId, String failureId) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling deleteEventFailureLog");
    }

    // verify the required parameter 'failureId' is set
    if (failureId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'failureId' when calling deleteEventFailureLog");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/failures/{failureId}"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "failureId" + "\\}", apiClient.escapeString(failureId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectDeleteFailureResult> localVarReturnType =
        new GenericType<ConnectDeleteFailureResult>() {};
    ConnectDeleteFailureResult localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "DELETE",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectDeleteFailureResult>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Deletes a specified Connect log entry.. Deletes a specified entry from the Connect Log.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param logId The ID of the connect log entry (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteEventLog(String accountId, String logId) throws ApiException {
    deleteEventLogWithHttpInfo(accountId, logId);
  }

  /**
   * Deletes a specified Connect log entry. Deletes a specified entry from the Connect Log.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param logId The ID of the connect log entry (required)
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Object> deleteEventLogWithHttpInfo(String accountId, String logId)
      throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling deleteEventLog");
    }

    // verify the required parameter 'logId' is set
    if (logId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'logId' when calling deleteEventLog");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/logs/{logId}"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "logId" + "\\}", apiClient.escapeString(logId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null);
    return new ApiResponse<Object>(apiClient.getStatusCode(), apiClient.getResponseHeaders(), null);
  }

  /**
   * Gets a list of Connect log entries.. Retrieves a list of connect log entries for your account.
   * ###### Note: The &#x60;enableLog&#x60; property in the Connect configuration must be set to
   * **true** to enable logging. If logging is not enabled, then no log entries are recorded.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteEventLogs(String accountId) throws ApiException {
    deleteEventLogsWithHttpInfo(accountId);
  }

  /**
   * Gets a list of Connect log entries. Retrieves a list of connect log entries for your account.
   * ###### Note: The &#x60;enableLog&#x60; property in the Connect configuration must be set to
   * **true** to enable logging. If logging is not enabled, then no log entries are recorded.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Object> deleteEventLogsWithHttpInfo(String accountId) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling deleteEventLogs");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/logs"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null);
    return new ApiResponse<Object>(apiClient.getStatusCode(), apiClient.getResponseHeaders(), null);
  }

  /**
   * Reserved. Reserved:
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param mobileNotifierConfigurationInformation (optional)
   * @return MobileNotifierConfigurationInformation
   * @throws ApiException if fails to make API call
   */
  public MobileNotifierConfigurationInformation deleteMobileNotifiers(
      String accountId,
      MobileNotifierConfigurationInformation mobileNotifierConfigurationInformation)
      throws ApiException {
    ApiResponse<MobileNotifierConfigurationInformation> localVarResponse =
        deleteMobileNotifiersWithHttpInfo(accountId, mobileNotifierConfigurationInformation);
    return localVarResponse.getData();
  }

  /**
   * Reserved Reserved:
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param mobileNotifierConfigurationInformation (optional)
   * @return MobileNotifierConfigurationInformation
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MobileNotifierConfigurationInformation> deleteMobileNotifiersWithHttpInfo(
      String accountId,
      MobileNotifierConfigurationInformation mobileNotifierConfigurationInformation)
      throws ApiException {
    Object localVarPostBody = mobileNotifierConfigurationInformation;

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling deleteMobileNotifiers");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/mobile_notifiers"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<MobileNotifierConfigurationInformation> localVarReturnType =
        new GenericType<MobileNotifierConfigurationInformation>() {};
    MobileNotifierConfigurationInformation localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "DELETE",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<MobileNotifierConfigurationInformation>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Get a Connect Configuration Information. Retrieves the information for the specified DocuSign
   * Connect configuration. ###### Note: Connect must be enabled for your account to use this
   * function.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @return ConnectConfigResults
   * @throws ApiException if fails to make API call
   */
  public ConnectConfigResults getConfiguration(String accountId, String connectId)
      throws ApiException {
    ApiResponse<ConnectConfigResults> localVarResponse =
        getConfigurationWithHttpInfo(accountId, connectId);
    return localVarResponse.getData();
  }

  /**
   * Get a Connect Configuration Information Retrieves the information for the specified DocuSign
   * Connect configuration. ###### Note: Connect must be enabled for your account to use this
   * function.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @return ConnectConfigResults
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectConfigResults> getConfigurationWithHttpInfo(
      String accountId, String connectId) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling getConfiguration");
    }

    // verify the required parameter 'connectId' is set
    if (connectId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'connectId' when calling getConfiguration");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/{connectId}"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "connectId" + "\\}", apiClient.escapeString(connectId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectConfigResults> localVarReturnType =
        new GenericType<ConnectConfigResults>() {};
    ConnectConfigResults localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectConfigResults>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }
  /// <summary>
  /// Returns all users from the configured Connect service.
  /// </summary>

  /** GetConnectAllUsersOptions Class. */
  public class GetConnectAllUsersOptions {
    private String count = null;
    private String domainUsersOnly = null;
    private String emailSubstring = null;
    private String startPosition = null;
    private String status = null;
    private String userNameSubstring = null;

    /** setCount method. */
    public void setCount(String count) {
      this.count = count;
    }

    /**
     * getCount method.
     *
     * @return String
     */
    public String getCount() {
      return this.count;
    }

    /** setDomainUsersOnly method. */
    public void setDomainUsersOnly(String domainUsersOnly) {
      this.domainUsersOnly = domainUsersOnly;
    }

    /**
     * getDomainUsersOnly method.
     *
     * @return String
     */
    public String getDomainUsersOnly() {
      return this.domainUsersOnly;
    }

    /** setEmailSubstring method. */
    public void setEmailSubstring(String emailSubstring) {
      this.emailSubstring = emailSubstring;
    }

    /**
     * getEmailSubstring method.
     *
     * @return String
     */
    public String getEmailSubstring() {
      return this.emailSubstring;
    }

    /** setStartPosition method. */
    public void setStartPosition(String startPosition) {
      this.startPosition = startPosition;
    }

    /**
     * getStartPosition method.
     *
     * @return String
     */
    public String getStartPosition() {
      return this.startPosition;
    }

    /** setStatus method. */
    public void setStatus(String status) {
      this.status = status;
    }

    /**
     * getStatus method.
     *
     * @return String
     */
    public String getStatus() {
      return this.status;
    }

    /** setUserNameSubstring method. */
    public void setUserNameSubstring(String userNameSubstring) {
      this.userNameSubstring = userNameSubstring;
    }

    /**
     * getUserNameSubstring method.
     *
     * @return String
     */
    public String getUserNameSubstring() {
      return this.userNameSubstring;
    }
  }

  /**
   * Returns all users from the configured Connect service..
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @return IntegratedConnectUserInfoList
   */
  public IntegratedConnectUserInfoList getConnectAllUsers(String accountId, String connectId)
      throws ApiException {
    return getConnectAllUsers(accountId, connectId, null);
  }

  /**
   * Returns all users from the configured Connect service..
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @param options for modifying the method behavior.
   * @return IntegratedConnectUserInfoList
   * @throws ApiException if fails to make API call
   */
  public IntegratedConnectUserInfoList getConnectAllUsers(
      String accountId, String connectId, ConnectApi.GetConnectAllUsersOptions options)
      throws ApiException {
    ApiResponse<IntegratedConnectUserInfoList> localVarResponse =
        getConnectAllUsersWithHttpInfo(accountId, connectId, options);
    return localVarResponse.getData();
  }

  /**
   * Returns all users from the configured Connect service.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @param options for modifying the method behavior.
   * @return IntegratedConnectUserInfoList
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<IntegratedConnectUserInfoList> getConnectAllUsersWithHttpInfo(
      String accountId, String connectId, ConnectApi.GetConnectAllUsersOptions options)
      throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling getConnectAllUsers");
    }

    // verify the required parameter 'connectId' is set
    if (connectId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'connectId' when calling getConnectAllUsers");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/{connectId}/all/users"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "connectId" + "\\}", apiClient.escapeString(connectId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    if (options != null) {
      localVarQueryParams.addAll(apiClient.parameterToPair("count", options.count));
    }
    if (options != null) {
      localVarQueryParams.addAll(
          apiClient.parameterToPair("domain_users_only", options.domainUsersOnly));
    }
    if (options != null) {
      localVarQueryParams.addAll(
          apiClient.parameterToPair("email_substring", options.emailSubstring));
    }
    if (options != null) {
      localVarQueryParams.addAll(
          apiClient.parameterToPair("start_position", options.startPosition));
    }
    if (options != null) {
      localVarQueryParams.addAll(apiClient.parameterToPair("status", options.status));
    }
    if (options != null) {
      localVarQueryParams.addAll(
          apiClient.parameterToPair("user_name_substring", options.userNameSubstring));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<IntegratedConnectUserInfoList> localVarReturnType =
        new GenericType<IntegratedConnectUserInfoList>() {};
    IntegratedConnectUserInfoList localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<IntegratedConnectUserInfoList>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Sets the Connect OAuth Config for the account..
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @return ConnectOAuthConfig
   * @throws ApiException if fails to make API call
   */
  public ConnectOAuthConfig getConnectOAuthConfig(String accountId) throws ApiException {
    ApiResponse<ConnectOAuthConfig> localVarResponse = getConnectOAuthConfigWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Sets the Connect OAuth Config for the account.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @return ConnectOAuthConfig
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectOAuthConfig> getConnectOAuthConfigWithHttpInfo(String accountId)
      throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling getConnectOAuthConfig");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/oauth"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectOAuthConfig> localVarReturnType = new GenericType<ConnectOAuthConfig>() {};
    ConnectOAuthConfig localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectOAuthConfig>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }
  /// <summary>
  /// Get the specified Connect log entry. Retrieves the specified Connect log entry for your
  // account.  ###### Note: The &#x60;enableLog&#x60; setting in the Connect configuration must be
  // set to true to enable logging. If logging is not enabled, then no log entries are recorded.
  /// </summary>

  /** GetEventLogOptions Class. */
  public class GetEventLogOptions {
    private String additionalInfo = null;

    /** setAdditionalInfo method. */
    public void setAdditionalInfo(String additionalInfo) {
      this.additionalInfo = additionalInfo;
    }

    /**
     * getAdditionalInfo method.
     *
     * @return String
     */
    public String getAdditionalInfo() {
      return this.additionalInfo;
    }
  }

  /**
   * Get the specified Connect log entry.. Retrieves the specified Connect log entry for your
   * account. ###### Note: The &#x60;enableLog&#x60; setting in the Connect configuration must be
   * set to true to enable logging. If logging is not enabled, then no log entries are recorded.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param logId The ID of the connect log entry (required)
   * @return ConnectLog
   */
  public ConnectLog getEventLog(String accountId, String logId) throws ApiException {
    return getEventLog(accountId, logId, null);
  }

  /**
   * Get the specified Connect log entry.. Retrieves the specified Connect log entry for your
   * account. ###### Note: The &#x60;enableLog&#x60; setting in the Connect configuration must be
   * set to true to enable logging. If logging is not enabled, then no log entries are recorded.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param logId The ID of the connect log entry (required)
   * @param options for modifying the method behavior.
   * @return ConnectLog
   * @throws ApiException if fails to make API call
   */
  public ConnectLog getEventLog(
      String accountId, String logId, ConnectApi.GetEventLogOptions options) throws ApiException {
    ApiResponse<ConnectLog> localVarResponse = getEventLogWithHttpInfo(accountId, logId, options);
    return localVarResponse.getData();
  }

  /**
   * Get the specified Connect log entry. Retrieves the specified Connect log entry for your
   * account. ###### Note: The &#x60;enableLog&#x60; setting in the Connect configuration must be
   * set to true to enable logging. If logging is not enabled, then no log entries are recorded.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param logId The ID of the connect log entry (required)
   * @param options for modifying the method behavior.
   * @return ConnectLog
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectLog> getEventLogWithHttpInfo(
      String accountId, String logId, ConnectApi.GetEventLogOptions options) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling getEventLog");
    }

    // verify the required parameter 'logId' is set
    if (logId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'logId' when calling getEventLog");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/logs/{logId}"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "logId" + "\\}", apiClient.escapeString(logId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    if (options != null) {
      localVarQueryParams.addAll(
          apiClient.parameterToPair("additional_info", options.additionalInfo));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectLog> localVarReturnType = new GenericType<ConnectLog>() {};
    ConnectLog localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectLog>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Get Connect Configuration Information. Retrieves all the DocuSign Custom Connect definitions
   * for the specified account. ###### Note: Connect must be enabled for your account to use this
   * function. This does not retrieve information for Connect configurations for Box, eOriginal, or
   * Salesforce.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @return ConnectConfigResults
   * @throws ApiException if fails to make API call
   */
  public ConnectConfigResults listConfigurations(String accountId) throws ApiException {
    ApiResponse<ConnectConfigResults> localVarResponse = listConfigurationsWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Get Connect Configuration Information Retrieves all the DocuSign Custom Connect definitions for
   * the specified account. ###### Note: Connect must be enabled for your account to use this
   * function. This does not retrieve information for Connect configurations for Box, eOriginal, or
   * Salesforce.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @return ConnectConfigResults
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectConfigResults> listConfigurationsWithHttpInfo(String accountId)
      throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling listConfigurations");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectConfigResults> localVarReturnType =
        new GenericType<ConnectConfigResults>() {};
    ConnectConfigResults localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectConfigResults>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }
  /// <summary>
  /// Gets the Connect failure log information. Retrieves the Connect Failure Log information. It
  // can be used to determine which envelopes failed to post, so a republish request can be created.
  /// </summary>

  /** ListEventFailureLogsOptions Class. */
  public class ListEventFailureLogsOptions {
    private String fromDate = null;
    private String toDate = null;

    /** setFromDate method. */
    public void setFromDate(String fromDate) {
      this.fromDate = fromDate;
    }

    /**
     * getFromDate method.
     *
     * @return String
     */
    public String getFromDate() {
      return this.fromDate;
    }

    /** setToDate method. */
    public void setToDate(String toDate) {
      this.toDate = toDate;
    }

    /**
     * getToDate method.
     *
     * @return String
     */
    public String getToDate() {
      return this.toDate;
    }
  }

  /**
   * Gets the Connect failure log information.. Retrieves the Connect Failure Log information. It
   * can be used to determine which envelopes failed to post, so a republish request can be created.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @return ConnectLogs
   */
  public ConnectLogs listEventFailureLogs(String accountId) throws ApiException {
    return listEventFailureLogs(accountId, null);
  }

  /**
   * Gets the Connect failure log information.. Retrieves the Connect Failure Log information. It
   * can be used to determine which envelopes failed to post, so a republish request can be created.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param options for modifying the method behavior.
   * @return ConnectLogs
   * @throws ApiException if fails to make API call
   */
  public ConnectLogs listEventFailureLogs(
      String accountId, ConnectApi.ListEventFailureLogsOptions options) throws ApiException {
    ApiResponse<ConnectLogs> localVarResponse =
        listEventFailureLogsWithHttpInfo(accountId, options);
    return localVarResponse.getData();
  }

  /**
   * Gets the Connect failure log information. Retrieves the Connect Failure Log information. It can
   * be used to determine which envelopes failed to post, so a republish request can be created.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param options for modifying the method behavior.
   * @return ConnectLogs
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectLogs> listEventFailureLogsWithHttpInfo(
      String accountId, ConnectApi.ListEventFailureLogsOptions options) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling listEventFailureLogs");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/failures"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    if (options != null) {
      localVarQueryParams.addAll(apiClient.parameterToPair("from_date", options.fromDate));
    }
    if (options != null) {
      localVarQueryParams.addAll(apiClient.parameterToPair("to_date", options.toDate));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectLogs> localVarReturnType = new GenericType<ConnectLogs>() {};
    ConnectLogs localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectLogs>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }
  /// <summary>
  /// Gets the Connect log. Retrieves a list of connect log entries for your account.  ###### Note:
  // The &#x60;enableLog&#x60; setting in the Connect configuration must be set to true to enable
  // logging. If logging is not enabled, then no log entries are recorded.
  /// </summary>

  /** ListEventLogsOptions Class. */
  public class ListEventLogsOptions {
    private String fromDate = null;
    private String toDate = null;

    /** setFromDate method. */
    public void setFromDate(String fromDate) {
      this.fromDate = fromDate;
    }

    /**
     * getFromDate method.
     *
     * @return String
     */
    public String getFromDate() {
      return this.fromDate;
    }

    /** setToDate method. */
    public void setToDate(String toDate) {
      this.toDate = toDate;
    }

    /**
     * getToDate method.
     *
     * @return String
     */
    public String getToDate() {
      return this.toDate;
    }
  }

  /**
   * Gets the Connect log.. Retrieves a list of connect log entries for your account. ###### Note:
   * The &#x60;enableLog&#x60; setting in the Connect configuration must be set to true to enable
   * logging. If logging is not enabled, then no log entries are recorded.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @return ConnectLogs
   */
  public ConnectLogs listEventLogs(String accountId) throws ApiException {
    return listEventLogs(accountId, null);
  }

  /**
   * Gets the Connect log.. Retrieves a list of connect log entries for your account. ###### Note:
   * The &#x60;enableLog&#x60; setting in the Connect configuration must be set to true to enable
   * logging. If logging is not enabled, then no log entries are recorded.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param options for modifying the method behavior.
   * @return ConnectLogs
   * @throws ApiException if fails to make API call
   */
  public ConnectLogs listEventLogs(String accountId, ConnectApi.ListEventLogsOptions options)
      throws ApiException {
    ApiResponse<ConnectLogs> localVarResponse = listEventLogsWithHttpInfo(accountId, options);
    return localVarResponse.getData();
  }

  /**
   * Gets the Connect log. Retrieves a list of connect log entries for your account. ###### Note:
   * The &#x60;enableLog&#x60; setting in the Connect configuration must be set to true to enable
   * logging. If logging is not enabled, then no log entries are recorded.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param options for modifying the method behavior.
   * @return ConnectLogs
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectLogs> listEventLogsWithHttpInfo(
      String accountId, ConnectApi.ListEventLogsOptions options) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling listEventLogs");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/logs"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    if (options != null) {
      localVarQueryParams.addAll(apiClient.parameterToPair("from_date", options.fromDate));
    }
    if (options != null) {
      localVarQueryParams.addAll(apiClient.parameterToPair("to_date", options.toDate));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectLogs> localVarReturnType = new GenericType<ConnectLogs>() {};
    ConnectLogs localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectLogs>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Reserved. Reserved:
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @return MobileNotifierConfigurationInformation
   * @throws ApiException if fails to make API call
   */
  public MobileNotifierConfigurationInformation listMobileNotifiers(String accountId)
      throws ApiException {
    ApiResponse<MobileNotifierConfigurationInformation> localVarResponse =
        listMobileNotifiersWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Reserved Reserved:
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @return MobileNotifierConfigurationInformation
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MobileNotifierConfigurationInformation> listMobileNotifiersWithHttpInfo(
      String accountId) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling listMobileNotifiers");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/mobile_notifiers"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<MobileNotifierConfigurationInformation> localVarReturnType =
        new GenericType<MobileNotifierConfigurationInformation>() {};
    MobileNotifierConfigurationInformation localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<MobileNotifierConfigurationInformation>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }
  /// <summary>
  /// Returns users from the configured Connect service. Returns users from the configured Connect
  // service.
  /// </summary>

  /** ListUsersOptions Class. */
  public class ListUsersOptions {
    private String count = null;
    private String emailSubstring = null;
    private String listIncludedUsers = null;
    private String startPosition = null;
    private String status = null;
    private String userNameSubstring = null;

    /** setCount method. */
    public void setCount(String count) {
      this.count = count;
    }

    /**
     * getCount method.
     *
     * @return String
     */
    public String getCount() {
      return this.count;
    }

    /** setEmailSubstring method. */
    public void setEmailSubstring(String emailSubstring) {
      this.emailSubstring = emailSubstring;
    }

    /**
     * getEmailSubstring method.
     *
     * @return String
     */
    public String getEmailSubstring() {
      return this.emailSubstring;
    }

    /** setListIncludedUsers method. */
    public void setListIncludedUsers(String listIncludedUsers) {
      this.listIncludedUsers = listIncludedUsers;
    }

    /**
     * getListIncludedUsers method.
     *
     * @return String
     */
    public String getListIncludedUsers() {
      return this.listIncludedUsers;
    }

    /** setStartPosition method. */
    public void setStartPosition(String startPosition) {
      this.startPosition = startPosition;
    }

    /**
     * getStartPosition method.
     *
     * @return String
     */
    public String getStartPosition() {
      return this.startPosition;
    }

    /** setStatus method. */
    public void setStatus(String status) {
      this.status = status;
    }

    /**
     * getStatus method.
     *
     * @return String
     */
    public String getStatus() {
      return this.status;
    }

    /** setUserNameSubstring method. */
    public void setUserNameSubstring(String userNameSubstring) {
      this.userNameSubstring = userNameSubstring;
    }

    /**
     * getUserNameSubstring method.
     *
     * @return String
     */
    public String getUserNameSubstring() {
      return this.userNameSubstring;
    }
  }

  /**
   * Returns users from the configured Connect service.. Returns users from the configured Connect
   * service.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @return IntegratedUserInfoList
   */
  public IntegratedUserInfoList listUsers(String accountId, String connectId) throws ApiException {
    return listUsers(accountId, connectId, null);
  }

  /**
   * Returns users from the configured Connect service.. Returns users from the configured Connect
   * service.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @param options for modifying the method behavior.
   * @return IntegratedUserInfoList
   * @throws ApiException if fails to make API call
   */
  public IntegratedUserInfoList listUsers(
      String accountId, String connectId, ConnectApi.ListUsersOptions options) throws ApiException {
    ApiResponse<IntegratedUserInfoList> localVarResponse =
        listUsersWithHttpInfo(accountId, connectId, options);
    return localVarResponse.getData();
  }

  /**
   * Returns users from the configured Connect service. Returns users from the configured Connect
   * service.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectId The ID of the custom Connect configuration being accessed. (required)
   * @param options for modifying the method behavior.
   * @return IntegratedUserInfoList
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<IntegratedUserInfoList> listUsersWithHttpInfo(
      String accountId, String connectId, ConnectApi.ListUsersOptions options) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling listUsers");
    }

    // verify the required parameter 'connectId' is set
    if (connectId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'connectId' when calling listUsers");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/{connectId}/users"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "connectId" + "\\}", apiClient.escapeString(connectId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    if (options != null) {
      localVarQueryParams.addAll(apiClient.parameterToPair("count", options.count));
    }
    if (options != null) {
      localVarQueryParams.addAll(
          apiClient.parameterToPair("email_substring", options.emailSubstring));
    }
    if (options != null) {
      localVarQueryParams.addAll(
          apiClient.parameterToPair("list_included_users", options.listIncludedUsers));
    }
    if (options != null) {
      localVarQueryParams.addAll(
          apiClient.parameterToPair("start_position", options.startPosition));
    }
    if (options != null) {
      localVarQueryParams.addAll(apiClient.parameterToPair("status", options.status));
    }
    if (options != null) {
      localVarQueryParams.addAll(
          apiClient.parameterToPair("user_name_substring", options.userNameSubstring));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<IntegratedUserInfoList> localVarReturnType =
        new GenericType<IntegratedUserInfoList>() {};
    IntegratedUserInfoList localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<IntegratedUserInfoList>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Republishes Connect information for the specified envelope.. Republishes Connect information
   * for the specified envelope.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param envelopeId The envelopeId Guid of the envelope being accessed. (required)
   * @return ConnectFailureResults
   * @throws ApiException if fails to make API call
   */
  public ConnectFailureResults retryEventForEnvelope(String accountId, String envelopeId)
      throws ApiException {
    ApiResponse<ConnectFailureResults> localVarResponse =
        retryEventForEnvelopeWithHttpInfo(accountId, envelopeId);
    return localVarResponse.getData();
  }

  /**
   * Republishes Connect information for the specified envelope. Republishes Connect information for
   * the specified envelope.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param envelopeId The envelopeId Guid of the envelope being accessed. (required)
   * @return ConnectFailureResults
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectFailureResults> retryEventForEnvelopeWithHttpInfo(
      String accountId, String envelopeId) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling retryEventForEnvelope");
    }

    // verify the required parameter 'envelopeId' is set
    if (envelopeId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'envelopeId' when calling retryEventForEnvelope");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/envelopes/{envelopeId}/retry_queue"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
            .replaceAll(
                "\\{" + "envelopeId" + "\\}", apiClient.escapeString(envelopeId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectFailureResults> localVarReturnType =
        new GenericType<ConnectFailureResults>() {};
    ConnectFailureResults localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "PUT",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectFailureResults>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Republishes Connect information for multiple envelopes.. Republishes Connect information for
   * the specified set of envelopes. The primary use is to republish Connect post failures by
   * including envelope IDs for the envelopes that failed to post in the request. The list of
   * envelope IDs that failed to post correctly can be retrieved by calling to [ML:GetConnectLog]
   * retrieve the failure log.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectFailureFilter (optional)
   * @return ConnectFailureResults
   * @throws ApiException if fails to make API call
   */
  public ConnectFailureResults retryEventForEnvelopes(
      String accountId, ConnectFailureFilter connectFailureFilter) throws ApiException {
    ApiResponse<ConnectFailureResults> localVarResponse =
        retryEventForEnvelopesWithHttpInfo(accountId, connectFailureFilter);
    return localVarResponse.getData();
  }

  /**
   * Republishes Connect information for multiple envelopes. Republishes Connect information for the
   * specified set of envelopes. The primary use is to republish Connect post failures by including
   * envelope IDs for the envelopes that failed to post in the request. The list of envelope IDs
   * that failed to post correctly can be retrieved by calling to [ML:GetConnectLog] retrieve the
   * failure log.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectFailureFilter (optional)
   * @return ConnectFailureResults
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectFailureResults> retryEventForEnvelopesWithHttpInfo(
      String accountId, ConnectFailureFilter connectFailureFilter) throws ApiException {
    Object localVarPostBody = connectFailureFilter;

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling retryEventForEnvelopes");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/envelopes/retry_queue"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectFailureResults> localVarReturnType =
        new GenericType<ConnectFailureResults>() {};
    ConnectFailureResults localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "PUT",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectFailureResults>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Updates a specified Connect configuration.. Updates the specified DocuSign Connect
   * configuration in your account. ###### Note: Connect must be enabled for your account to use
   * this function. This cannot be used to update Connect configurations for Box, eOriginal, or
   * Salesforce.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectCustomConfiguration (optional)
   * @return ConnectCustomConfiguration
   * @throws ApiException if fails to make API call
   */
  public ConnectCustomConfiguration updateConfiguration(
      String accountId, ConnectCustomConfiguration connectCustomConfiguration) throws ApiException {
    ApiResponse<ConnectCustomConfiguration> localVarResponse =
        updateConfigurationWithHttpInfo(accountId, connectCustomConfiguration);
    return localVarResponse.getData();
  }

  /**
   * Updates a specified Connect configuration. Updates the specified DocuSign Connect configuration
   * in your account. ###### Note: Connect must be enabled for your account to use this function.
   * This cannot be used to update Connect configurations for Box, eOriginal, or Salesforce.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectCustomConfiguration (optional)
   * @return ConnectCustomConfiguration
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectCustomConfiguration> updateConfigurationWithHttpInfo(
      String accountId, ConnectCustomConfiguration connectCustomConfiguration) throws ApiException {
    Object localVarPostBody = connectCustomConfiguration;

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling updateConfiguration");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectCustomConfiguration> localVarReturnType =
        new GenericType<ConnectCustomConfiguration>() {};
    ConnectCustomConfiguration localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "PUT",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectCustomConfiguration>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Updates the existing Connect OAuth Config for the account..
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectOAuthConfig (optional)
   * @return ConnectOAuthConfig
   * @throws ApiException if fails to make API call
   */
  public ConnectOAuthConfig updateConnectOAuthConfig(
      String accountId, ConnectOAuthConfig connectOAuthConfig) throws ApiException {
    ApiResponse<ConnectOAuthConfig> localVarResponse =
        updateConnectOAuthConfigWithHttpInfo(accountId, connectOAuthConfig);
    return localVarResponse.getData();
  }

  /**
   * Updates the existing Connect OAuth Config for the account.
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param connectOAuthConfig (optional)
   * @return ConnectOAuthConfig
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ConnectOAuthConfig> updateConnectOAuthConfigWithHttpInfo(
      String accountId, ConnectOAuthConfig connectOAuthConfig) throws ApiException {
    Object localVarPostBody = connectOAuthConfig;

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling updateConnectOAuthConfig");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/oauth"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<ConnectOAuthConfig> localVarReturnType = new GenericType<ConnectOAuthConfig>() {};
    ConnectOAuthConfig localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "PUT",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<ConnectOAuthConfig>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }

  /**
   * Reserved. Reserved:
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param mobileNotifierConfigurationInformation (optional)
   * @return MobileNotifierConfigurationInformation
   * @throws ApiException if fails to make API call
   */
  public MobileNotifierConfigurationInformation updateMobileNotifiers(
      String accountId,
      MobileNotifierConfigurationInformation mobileNotifierConfigurationInformation)
      throws ApiException {
    ApiResponse<MobileNotifierConfigurationInformation> localVarResponse =
        updateMobileNotifiersWithHttpInfo(accountId, mobileNotifierConfigurationInformation);
    return localVarResponse.getData();
  }

  /**
   * Reserved Reserved:
   *
   * @param accountId The external account number (int) or account ID Guid. (required)
   * @param mobileNotifierConfigurationInformation (optional)
   * @return MobileNotifierConfigurationInformation
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MobileNotifierConfigurationInformation> updateMobileNotifiersWithHttpInfo(
      String accountId,
      MobileNotifierConfigurationInformation mobileNotifierConfigurationInformation)
      throws ApiException {
    Object localVarPostBody = mobileNotifierConfigurationInformation;

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling updateMobileNotifiers");
    }

    // create path and map variables
    String localVarPath =
        "/v2.1/accounts/{accountId}/connect/mobile_notifiers"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {};

    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<MobileNotifierConfigurationInformation> localVarReturnType =
        new GenericType<MobileNotifierConfigurationInformation>() {};
    MobileNotifierConfigurationInformation localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "PUT",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<MobileNotifierConfigurationInformation>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }
}
