/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="This object contains details about a captive (embedded) recipient.")
public class CaptiveRecipient
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="clientUserId")
    private String clientUserId = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="userName")
    private String userName = null;

    public CaptiveRecipient clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Schema(description="Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. ")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public CaptiveRecipient email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Specifies the email address associated with the captive recipient.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CaptiveRecipient errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Schema(description="Array or errors.")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public CaptiveRecipient userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(description="Specifies the user name associated with the captive recipient.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaptiveRecipient captiveRecipient = (CaptiveRecipient)o;
        return Objects.equals(this.clientUserId, captiveRecipient.clientUserId) && Objects.equals(this.email, captiveRecipient.email) && Objects.equals(this.errorDetails, captiveRecipient.errorDetails) && Objects.equals(this.userName, captiveRecipient.userName);
    }

    public int hashCode() {
        return Objects.hash(this.clientUserId, this.email, this.errorDetails, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaptiveRecipient {\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

