/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermValueList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class TermFixedLengthLongArrayList
extends TermValueList<long[]> {
    private static Logger log = Logger.getLogger(TermFixedLengthLongArrayList.class);
    protected long[] _elements = null;
    protected int width;
    private long[] sanity;
    private boolean withDummy = true;

    public TermFixedLengthLongArrayList(int width) {
        this.width = width;
        this.sanity = new long[width];
        this.sanity[width - 1] = -1L;
    }

    public TermFixedLengthLongArrayList(int width, int capacity) {
        super(capacity * width);
        this.width = width;
        this.sanity = new long[width];
        this.sanity[width - 1] = -1L;
    }

    protected long[] parse(String s) {
        long[] r = new long[this.width];
        if (s == null || s.length() == 0) {
            return r;
        }
        String[] a = s.split(",");
        if (a.length != this.width) {
            throw new RuntimeException(s + " is not a " + this.width + " fixed width long.");
        }
        for (int i = 0; i < this.width; ++i) {
            r[i] = Long.parseLong(a[i]);
            if (r[i] >= 0L) continue;
            throw new RuntimeException("We only support non-negative numbers: " + s);
        }
        return r;
    }

    @Override
    public boolean add(String o) {
        int i = 0;
        long cmp = 0L;
        if (this._innerList.size() == 0 && o != null) {
            this.withDummy = false;
        }
        long[] item = this.parse(o);
        for (i = 0; i < this.width && (cmp = item[i] - this.sanity[i]) == 0L; ++i) {
        }
        if (cmp <= 0L) {
            throw new RuntimeException("Values need to be added in ascending order and we only support non-negative numbers: " + o);
        }
        for (i = 0; i < this.width; ++i) {
            if (((LongArrayList)this._innerList).add(item[i])) continue;
            if (i > 0) {
                ((LongArrayList)this._innerList).removeElements(this._innerList.size() - i, this._innerList.size() - 1);
            }
            return false;
        }
        if (this._innerList.size() > this.width || !this.withDummy) {
            for (i = 0; i < this.width; ++i) {
                this.sanity[i] = item[i];
            }
        }
        return true;
    }

    @Override
    protected List<?> buildPrimitiveList(int capacity) {
        this._type = long[].class;
        return capacity > 0 ? new LongArrayList(capacity) : new LongArrayList();
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public String get(int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._elements[index *= this.width]);
        int left = this.width;
        ++index;
        while (left > 1) {
            sb.append(',');
            sb.append(this._elements[index]);
            --left;
            ++index;
        }
        return sb.toString();
    }

    @Override
    public long[] getRawValue(int index) {
        long[] val = new long[this.width];
        index *= this.width;
        for (int i = 0; i < this.width; ++i) {
            val[i] = this._elements[index + i];
        }
        return val;
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator iter = this._innerList.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public String next() {
                long[] val = new long[TermFixedLengthLongArrayList.this.width];
                for (int i = 0; i < TermFixedLengthLongArrayList.this.width; ++i) {
                    val[i] = (Long)iter.next();
                }
                return TermFixedLengthLongArrayList.this.format(val);
            }

            @Override
            public void remove() {
                for (int i = 0; i < TermFixedLengthLongArrayList.this.width; ++i) {
                    iter.remove();
                }
            }
        };
    }

    @Override
    public int size() {
        return this._innerList.size() / this.width;
    }

    @Override
    public Object[] toArray() {
        Object[] retArray = new Object[this.size()];
        for (int i = 0; i < retArray.length; ++i) {
            retArray[i] = this.get(i);
        }
        return retArray;
    }

    public long[][] toArray(long[][] a) {
        long[][] retArray = new long[this.size()][];
        for (int i = 0; i < retArray.length; ++i) {
            retArray[i] = this.getRawValue(i);
        }
        return retArray;
    }

    @Override
    public String format(Object o) {
        long[] val;
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            o = this.parse((String)o);
        }
        if ((val = (long[])o).length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(val[0]);
        for (int i = 1; i < val.length; ++i) {
            sb.append(',');
            sb.append(val[i]);
        }
        return sb.toString();
    }

    public long[] getPrimitiveValue(int index) {
        long[] r = new long[this.width];
        if ((index *= this.width) < this._elements.length) {
            int i = 0;
            while (i < this.width) {
                r[i] = this._elements[index];
                ++i;
                ++index;
            }
        } else {
            r[this.width - 1] = -1L;
        }
        return r;
    }

    protected int binarySearch(long[] key) {
        return this.binarySearch(key, 0, this._elements.length / this.width - 1);
    }

    protected int binarySearch(long[] key, int low, int high) {
        int mid = 0;
        long cmp = -1L;
        while (low <= high) {
            mid = (low + high) / 2;
            int index = mid * this.width;
            int i = 0;
            while (i < this.width && (cmp = key[i] - this._elements[index]) == 0L) {
                ++i;
                ++index;
            }
            if (cmp > 0L) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0L) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(mid + 1);
    }

    @Override
    public int indexOf(Object o) {
        if (this.withDummy) {
            if (o instanceof String) {
                o = this.parse((String)o);
            }
            return this.binarySearch((long[])o, 1, this._elements.length / this.width - 1);
        }
        if (o instanceof String) {
            o = this.parse((String)o);
        }
        return this.binarySearch((long[])o);
    }

    public int indexOf(long[] val) {
        if (this.withDummy) {
            return this.binarySearch(val, 1, this._elements.length / this.width - 1);
        }
        return this.binarySearch(val);
    }

    @Override
    public int indexOfWithType(long[] val) {
        if (this.withDummy) {
            return this.binarySearch(val, 1, this._elements.length / this.width - 1);
        }
        return this.binarySearch(val);
    }

    @Override
    public void seal() {
        ((LongArrayList)this._innerList).trim();
        this._elements = ((LongArrayList)this._innerList).elements();
    }

    public boolean contains(long[] val) {
        if (this.withDummy) {
            return this.binarySearch(val, 1, this._elements.length / this.width - 1) >= 0;
        }
        return this.binarySearch(val) >= 0;
    }

    @Override
    public boolean containsWithType(long[] val) {
        if (this.withDummy) {
            return this.binarySearch(val, 1, this._elements.length / this.width - 1) >= 0;
        }
        return this.binarySearch(val) >= 0;
    }
}

