// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The secret item containing secret metadata.
 */
@Fluent
public class SecretItem implements JsonSerializable<SecretItem> {
    /*
     * Secret identifier.
     */
    private String id;

    /*
     * The secret management attributes.
     */
    private SecretAttributes attributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    private Map<String, String> tags;

    /*
     * Type of the secret value such as a password.
     */
    private String contentType;

    /*
     * True if the secret's lifetime is managed by key vault. If this is a key backing a certificate, then managed will
     * be true.
     */
    private Boolean managed;

    /**
     * Creates an instance of SecretItem class.
     */
    public SecretItem() {
    }

    /**
     * Get the id property: Secret identifier.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Secret identifier.
     * 
     * @param id the id value to set.
     * @return the SecretItem object itself.
     */
    public SecretItem setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the attributes property: The secret management attributes.
     * 
     * @return the attributes value.
     */
    public SecretAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The secret management attributes.
     * 
     * @param attributes the attributes value to set.
     * @return the SecretItem object itself.
     */
    public SecretItem setAttributes(SecretAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @param tags the tags value to set.
     * @return the SecretItem object itself.
     */
    public SecretItem setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the contentType property: Type of the secret value such as a password.
     * 
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Type of the secret value such as a password.
     * 
     * @param contentType the contentType value to set.
     * @return the SecretItem object itself.
     */
    public SecretItem setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the managed property: True if the secret's lifetime is managed by key vault. If this is a key backing a
     * certificate, then managed will be true.
     * 
     * @return the managed value.
     */
    public Boolean isManaged() {
        return this.managed;
    }

    /**
     * Set the managed property: True if the secret's lifetime is managed by key vault. If this is a key backing a
     * certificate, then managed will be true.
     * 
     * @param managed the managed value to set.
     * @return the SecretItem object itself.
     */
    SecretItem setManaged(Boolean managed) {
        this.managed = managed;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("contentType", this.contentType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretItem if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the SecretItem.
     */
    public static SecretItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretItem deserializedSecretItem = new SecretItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSecretItem.id = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedSecretItem.attributes = SecretAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSecretItem.tags = tags;
                } else if ("contentType".equals(fieldName)) {
                    deserializedSecretItem.contentType = reader.getString();
                } else if ("managed".equals(fieldName)) {
                    deserializedSecretItem.managed = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecretItem;
        });
    }
}
