/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.data.appconfiguration.implementation.ConfigurationClientCredentials;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class ConfigurationCredentialsPolicy
implements HttpPipelinePolicy {
    private final ConfigurationClientCredentials credentials;

    public ConfigurationCredentialsPolicy(ConfigurationClientCredentials credentials) {
        Objects.requireNonNull(credentials, "'credential' can not be a null value.");
        this.credentials = credentials;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        this.credentials.setAuthorizationHeaders(context.getHttpRequest());
        return next.process();
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        this.credentials.setAuthorizationHeaders(context.getHttpRequest());
        return next.processSync();
    }
}

