/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.CountClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.transform.CloseStatusFilterJsonMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ExecutionTimeFilterJsonMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionFilterJsonMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CountClosedWorkflowExecutionsRequestMarshaller
implements Marshaller<Request<CountClosedWorkflowExecutionsRequest>, CountClosedWorkflowExecutionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CountClosedWorkflowExecutionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CountClosedWorkflowExecutionsRequest> marshall(CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) {
        if (countClosedWorkflowExecutionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)countClosedWorkflowExecutionsRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.CountClosedWorkflowExecutions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (countClosedWorkflowExecutionsRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(countClosedWorkflowExecutionsRequest.getDomain());
            }
            if (countClosedWorkflowExecutionsRequest.getStartTimeFilter() != null) {
                jsonGenerator.writeFieldName("startTimeFilter");
                ExecutionTimeFilterJsonMarshaller.getInstance().marshall(countClosedWorkflowExecutionsRequest.getStartTimeFilter(), jsonGenerator);
            }
            if (countClosedWorkflowExecutionsRequest.getCloseTimeFilter() != null) {
                jsonGenerator.writeFieldName("closeTimeFilter");
                ExecutionTimeFilterJsonMarshaller.getInstance().marshall(countClosedWorkflowExecutionsRequest.getCloseTimeFilter(), jsonGenerator);
            }
            if (countClosedWorkflowExecutionsRequest.getExecutionFilter() != null) {
                jsonGenerator.writeFieldName("executionFilter");
                WorkflowExecutionFilterJsonMarshaller.getInstance().marshall(countClosedWorkflowExecutionsRequest.getExecutionFilter(), jsonGenerator);
            }
            if (countClosedWorkflowExecutionsRequest.getTypeFilter() != null) {
                jsonGenerator.writeFieldName("typeFilter");
                WorkflowTypeFilterJsonMarshaller.getInstance().marshall(countClosedWorkflowExecutionsRequest.getTypeFilter(), jsonGenerator);
            }
            if (countClosedWorkflowExecutionsRequest.getTagFilter() != null) {
                jsonGenerator.writeFieldName("tagFilter");
                TagFilterJsonMarshaller.getInstance().marshall(countClosedWorkflowExecutionsRequest.getTagFilter(), jsonGenerator);
            }
            if (countClosedWorkflowExecutionsRequest.getCloseStatusFilter() != null) {
                jsonGenerator.writeFieldName("closeStatusFilter");
                CloseStatusFilterJsonMarshaller.getInstance().marshall(countClosedWorkflowExecutionsRequest.getCloseStatusFilter(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

