/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ColumnOrderingType;
import com.amazonaws.services.quicksight.model.UndefinedSpecifiedValueType;
import com.amazonaws.services.quicksight.model.transform.ComparativeOrderMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComparativeOrder
implements Serializable,
Cloneable,
StructuredPojo {
    private String useOrdering;
    private List<String> specifedOrder;
    private String treatUndefinedSpecifiedValues;

    public void setUseOrdering(String useOrdering) {
        this.useOrdering = useOrdering;
    }

    public String getUseOrdering() {
        return this.useOrdering;
    }

    public ComparativeOrder withUseOrdering(String useOrdering) {
        this.setUseOrdering(useOrdering);
        return this;
    }

    public ComparativeOrder withUseOrdering(ColumnOrderingType useOrdering) {
        this.useOrdering = useOrdering.toString();
        return this;
    }

    public List<String> getSpecifedOrder() {
        return this.specifedOrder;
    }

    public void setSpecifedOrder(Collection<String> specifedOrder) {
        if (specifedOrder == null) {
            this.specifedOrder = null;
            return;
        }
        this.specifedOrder = new ArrayList<String>(specifedOrder);
    }

    public ComparativeOrder withSpecifedOrder(String ... specifedOrder) {
        if (this.specifedOrder == null) {
            this.setSpecifedOrder(new ArrayList<String>(specifedOrder.length));
        }
        for (String ele : specifedOrder) {
            this.specifedOrder.add(ele);
        }
        return this;
    }

    public ComparativeOrder withSpecifedOrder(Collection<String> specifedOrder) {
        this.setSpecifedOrder(specifedOrder);
        return this;
    }

    public void setTreatUndefinedSpecifiedValues(String treatUndefinedSpecifiedValues) {
        this.treatUndefinedSpecifiedValues = treatUndefinedSpecifiedValues;
    }

    public String getTreatUndefinedSpecifiedValues() {
        return this.treatUndefinedSpecifiedValues;
    }

    public ComparativeOrder withTreatUndefinedSpecifiedValues(String treatUndefinedSpecifiedValues) {
        this.setTreatUndefinedSpecifiedValues(treatUndefinedSpecifiedValues);
        return this;
    }

    public ComparativeOrder withTreatUndefinedSpecifiedValues(UndefinedSpecifiedValueType treatUndefinedSpecifiedValues) {
        this.treatUndefinedSpecifiedValues = treatUndefinedSpecifiedValues.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUseOrdering() != null) {
            sb.append("UseOrdering: ").append(this.getUseOrdering()).append(",");
        }
        if (this.getSpecifedOrder() != null) {
            sb.append("SpecifedOrder: ").append(this.getSpecifedOrder()).append(",");
        }
        if (this.getTreatUndefinedSpecifiedValues() != null) {
            sb.append("TreatUndefinedSpecifiedValues: ").append(this.getTreatUndefinedSpecifiedValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparativeOrder)) {
            return false;
        }
        ComparativeOrder other = (ComparativeOrder)obj;
        if (other.getUseOrdering() == null ^ this.getUseOrdering() == null) {
            return false;
        }
        if (other.getUseOrdering() != null && !other.getUseOrdering().equals(this.getUseOrdering())) {
            return false;
        }
        if (other.getSpecifedOrder() == null ^ this.getSpecifedOrder() == null) {
            return false;
        }
        if (other.getSpecifedOrder() != null && !other.getSpecifedOrder().equals(this.getSpecifedOrder())) {
            return false;
        }
        if (other.getTreatUndefinedSpecifiedValues() == null ^ this.getTreatUndefinedSpecifiedValues() == null) {
            return false;
        }
        return other.getTreatUndefinedSpecifiedValues() == null || other.getTreatUndefinedSpecifiedValues().equals(this.getTreatUndefinedSpecifiedValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUseOrdering() == null ? 0 : this.getUseOrdering().hashCode());
        hashCode = 31 * hashCode + (this.getSpecifedOrder() == null ? 0 : this.getSpecifedOrder().hashCode());
        hashCode = 31 * hashCode + (this.getTreatUndefinedSpecifiedValues() == null ? 0 : this.getTreatUndefinedSpecifiedValues().hashCode());
        return hashCode;
    }

    public ComparativeOrder clone() {
        try {
            return (ComparativeOrder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComparativeOrderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

