/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeevents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalizeevents.model.MetricAttribution;
import com.amazonaws.services.personalizeevents.model.transform.EventMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Event
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventId;
    private String eventType;
    private Float eventValue;
    private String itemId;
    private String properties;
    private Date sentAt;
    private String recommendationId;
    private List<String> impression;
    private MetricAttribution metricAttribution;

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Event withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Event withEventType(String eventType) {
        this.setEventType(eventType);
        return this;
    }

    public void setEventValue(Float eventValue) {
        this.eventValue = eventValue;
    }

    public Float getEventValue() {
        return this.eventValue;
    }

    public Event withEventValue(Float eventValue) {
        this.setEventValue(eventValue);
        return this;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Event withItemId(String itemId) {
        this.setItemId(itemId);
        return this;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getProperties() {
        return this.properties;
    }

    public Event withProperties(String properties) {
        this.setProperties(properties);
        return this;
    }

    public void setSentAt(Date sentAt) {
        this.sentAt = sentAt;
    }

    public Date getSentAt() {
        return this.sentAt;
    }

    public Event withSentAt(Date sentAt) {
        this.setSentAt(sentAt);
        return this;
    }

    public void setRecommendationId(String recommendationId) {
        this.recommendationId = recommendationId;
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public Event withRecommendationId(String recommendationId) {
        this.setRecommendationId(recommendationId);
        return this;
    }

    public List<String> getImpression() {
        return this.impression;
    }

    public void setImpression(Collection<String> impression) {
        if (impression == null) {
            this.impression = null;
            return;
        }
        this.impression = new ArrayList<String>(impression);
    }

    public Event withImpression(String ... impression) {
        if (this.impression == null) {
            this.setImpression(new ArrayList<String>(impression.length));
        }
        for (String ele : impression) {
            this.impression.add(ele);
        }
        return this;
    }

    public Event withImpression(Collection<String> impression) {
        this.setImpression(impression);
        return this;
    }

    public void setMetricAttribution(MetricAttribution metricAttribution) {
        this.metricAttribution = metricAttribution;
    }

    public MetricAttribution getMetricAttribution() {
        return this.metricAttribution;
    }

    public Event withMetricAttribution(MetricAttribution metricAttribution) {
        this.setMetricAttribution(metricAttribution);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getEventType() != null) {
            sb.append("EventType: ").append(this.getEventType()).append(",");
        }
        if (this.getEventValue() != null) {
            sb.append("EventValue: ").append(this.getEventValue()).append(",");
        }
        if (this.getItemId() != null) {
            sb.append("ItemId: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSentAt() != null) {
            sb.append("SentAt: ").append(this.getSentAt()).append(",");
        }
        if (this.getRecommendationId() != null) {
            sb.append("RecommendationId: ").append(this.getRecommendationId()).append(",");
        }
        if (this.getImpression() != null) {
            sb.append("Impression: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMetricAttribution() != null) {
            sb.append("MetricAttribution: ").append(this.getMetricAttribution());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getEventType() == null ^ this.getEventType() == null) {
            return false;
        }
        if (other.getEventType() != null && !other.getEventType().equals(this.getEventType())) {
            return false;
        }
        if (other.getEventValue() == null ^ this.getEventValue() == null) {
            return false;
        }
        if (other.getEventValue() != null && !other.getEventValue().equals(this.getEventValue())) {
            return false;
        }
        if (other.getItemId() == null ^ this.getItemId() == null) {
            return false;
        }
        if (other.getItemId() != null && !other.getItemId().equals(this.getItemId())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getSentAt() == null ^ this.getSentAt() == null) {
            return false;
        }
        if (other.getSentAt() != null && !other.getSentAt().equals(this.getSentAt())) {
            return false;
        }
        if (other.getRecommendationId() == null ^ this.getRecommendationId() == null) {
            return false;
        }
        if (other.getRecommendationId() != null && !other.getRecommendationId().equals(this.getRecommendationId())) {
            return false;
        }
        if (other.getImpression() == null ^ this.getImpression() == null) {
            return false;
        }
        if (other.getImpression() != null && !other.getImpression().equals(this.getImpression())) {
            return false;
        }
        if (other.getMetricAttribution() == null ^ this.getMetricAttribution() == null) {
            return false;
        }
        return other.getMetricAttribution() == null || other.getMetricAttribution().equals(this.getMetricAttribution());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getEventType() == null ? 0 : this.getEventType().hashCode());
        hashCode = 31 * hashCode + (this.getEventValue() == null ? 0 : this.getEventValue().hashCode());
        hashCode = 31 * hashCode + (this.getItemId() == null ? 0 : this.getItemId().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getSentAt() == null ? 0 : this.getSentAt().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationId() == null ? 0 : this.getRecommendationId().hashCode());
        hashCode = 31 * hashCode + (this.getImpression() == null ? 0 : this.getImpression().hashCode());
        hashCode = 31 * hashCode + (this.getMetricAttribution() == null ? 0 : this.getMetricAttribution().hashCode());
        return hashCode;
    }

    public Event clone() {
        try {
            return (Event)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

