/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.paymentcryptographydata.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Parameters that are required to generate or verify Dynamic Card Verification Value (dCVV).
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/DynamicCardVerificationCode"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DynamicCardVerificationCode implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * A random number generated by the issuer.
     * </p>
     */
    private String unpredictableNumber;
    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     */
    private String panSequenceNumber;
    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     */
    private String applicationTransactionCounter;
    /**
     * <p>
     * The data on the two tracks of magnetic cards used for financial transactions. This includes the cardholder name,
     * PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to validate the data
     * received.
     * </p>
     */
    private String trackData;

    /**
     * <p>
     * A random number generated by the issuer.
     * </p>
     * 
     * @param unpredictableNumber
     *        A random number generated by the issuer.
     */

    public void setUnpredictableNumber(String unpredictableNumber) {
        this.unpredictableNumber = unpredictableNumber;
    }

    /**
     * <p>
     * A random number generated by the issuer.
     * </p>
     * 
     * @return A random number generated by the issuer.
     */

    public String getUnpredictableNumber() {
        return this.unpredictableNumber;
    }

    /**
     * <p>
     * A random number generated by the issuer.
     * </p>
     * 
     * @param unpredictableNumber
     *        A random number generated by the issuer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DynamicCardVerificationCode withUnpredictableNumber(String unpredictableNumber) {
        setUnpredictableNumber(unpredictableNumber);
        return this;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @param panSequenceNumber
     *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     */

    public void setPanSequenceNumber(String panSequenceNumber) {
        this.panSequenceNumber = panSequenceNumber;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @return A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     */

    public String getPanSequenceNumber() {
        return this.panSequenceNumber;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @param panSequenceNumber
     *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DynamicCardVerificationCode withPanSequenceNumber(String panSequenceNumber) {
        setPanSequenceNumber(panSequenceNumber);
        return this;
    }

    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     * 
     * @param applicationTransactionCounter
     *        The transaction counter value that comes from the terminal.
     */

    public void setApplicationTransactionCounter(String applicationTransactionCounter) {
        this.applicationTransactionCounter = applicationTransactionCounter;
    }

    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     * 
     * @return The transaction counter value that comes from the terminal.
     */

    public String getApplicationTransactionCounter() {
        return this.applicationTransactionCounter;
    }

    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     * 
     * @param applicationTransactionCounter
     *        The transaction counter value that comes from the terminal.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DynamicCardVerificationCode withApplicationTransactionCounter(String applicationTransactionCounter) {
        setApplicationTransactionCounter(applicationTransactionCounter);
        return this;
    }

    /**
     * <p>
     * The data on the two tracks of magnetic cards used for financial transactions. This includes the cardholder name,
     * PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to validate the data
     * received.
     * </p>
     * 
     * @param trackData
     *        The data on the two tracks of magnetic cards used for financial transactions. This includes the cardholder
     *        name, PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to validate the
     *        data received.
     */

    public void setTrackData(String trackData) {
        this.trackData = trackData;
    }

    /**
     * <p>
     * The data on the two tracks of magnetic cards used for financial transactions. This includes the cardholder name,
     * PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to validate the data
     * received.
     * </p>
     * 
     * @return The data on the two tracks of magnetic cards used for financial transactions. This includes the
     *         cardholder name, PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to
     *         validate the data received.
     */

    public String getTrackData() {
        return this.trackData;
    }

    /**
     * <p>
     * The data on the two tracks of magnetic cards used for financial transactions. This includes the cardholder name,
     * PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to validate the data
     * received.
     * </p>
     * 
     * @param trackData
     *        The data on the two tracks of magnetic cards used for financial transactions. This includes the cardholder
     *        name, PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to validate the
     *        data received.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DynamicCardVerificationCode withTrackData(String trackData) {
        setTrackData(trackData);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getUnpredictableNumber() != null)
            sb.append("UnpredictableNumber: ").append(getUnpredictableNumber()).append(",");
        if (getPanSequenceNumber() != null)
            sb.append("PanSequenceNumber: ").append(getPanSequenceNumber()).append(",");
        if (getApplicationTransactionCounter() != null)
            sb.append("ApplicationTransactionCounter: ").append(getApplicationTransactionCounter()).append(",");
        if (getTrackData() != null)
            sb.append("TrackData: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DynamicCardVerificationCode == false)
            return false;
        DynamicCardVerificationCode other = (DynamicCardVerificationCode) obj;
        if (other.getUnpredictableNumber() == null ^ this.getUnpredictableNumber() == null)
            return false;
        if (other.getUnpredictableNumber() != null && other.getUnpredictableNumber().equals(this.getUnpredictableNumber()) == false)
            return false;
        if (other.getPanSequenceNumber() == null ^ this.getPanSequenceNumber() == null)
            return false;
        if (other.getPanSequenceNumber() != null && other.getPanSequenceNumber().equals(this.getPanSequenceNumber()) == false)
            return false;
        if (other.getApplicationTransactionCounter() == null ^ this.getApplicationTransactionCounter() == null)
            return false;
        if (other.getApplicationTransactionCounter() != null
                && other.getApplicationTransactionCounter().equals(this.getApplicationTransactionCounter()) == false)
            return false;
        if (other.getTrackData() == null ^ this.getTrackData() == null)
            return false;
        if (other.getTrackData() != null && other.getTrackData().equals(this.getTrackData()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getUnpredictableNumber() == null) ? 0 : getUnpredictableNumber().hashCode());
        hashCode = prime * hashCode + ((getPanSequenceNumber() == null) ? 0 : getPanSequenceNumber().hashCode());
        hashCode = prime * hashCode + ((getApplicationTransactionCounter() == null) ? 0 : getApplicationTransactionCounter().hashCode());
        hashCode = prime * hashCode + ((getTrackData() == null) ? 0 : getTrackData().hashCode());
        return hashCode;
    }

    @Override
    public DynamicCardVerificationCode clone() {
        try {
            return (DynamicCardVerificationCode) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.paymentcryptographydata.model.transform.DynamicCardVerificationCodeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
