/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mainframemodernization.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mainframemodernization.model.DataSet;

@SdkInternalApi
public class DataSetMarshaller {
    private static final MarshallingInfo<String> DATASETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("datasetName").build();
    private static final MarshallingInfo<StructuredPojo> DATASETORG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("datasetOrg").build();
    private static final MarshallingInfo<StructuredPojo> RECORDLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recordLength").build();
    private static final MarshallingInfo<String> RELATIVEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relativePath").build();
    private static final MarshallingInfo<String> STORAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storageType").build();
    private static final DataSetMarshaller instance = new DataSetMarshaller();

    public static DataSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSet dataSet, ProtocolMarshaller protocolMarshaller) {
        if (dataSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSet.getDatasetName(), DATASETNAME_BINDING);
            protocolMarshaller.marshall((Object)dataSet.getDatasetOrg(), DATASETORG_BINDING);
            protocolMarshaller.marshall((Object)dataSet.getRecordLength(), RECORDLENGTH_BINDING);
            protocolMarshaller.marshall((Object)dataSet.getRelativePath(), RELATIVEPATH_BINDING);
            protocolMarshaller.marshall((Object)dataSet.getStorageType(), STORAGETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

