/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iot.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.iot.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * CreateDomainConfigurationRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class CreateDomainConfigurationRequestMarshaller {

    private static final MarshallingInfo<String> DOMAINCONFIGURATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("domainConfigurationName").build();
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainName").build();
    private static final MarshallingInfo<List> SERVERCERTIFICATEARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverCertificateArns").build();
    private static final MarshallingInfo<String> VALIDATIONCERTIFICATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("validationCertificateArn").build();
    private static final MarshallingInfo<StructuredPojo> AUTHORIZERCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerConfig").build();
    private static final MarshallingInfo<String> SERVICETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceType").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("tags").build();
    private static final MarshallingInfo<StructuredPojo> TLSCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tlsConfig").build();
    private static final MarshallingInfo<StructuredPojo> SERVERCERTIFICATECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverCertificateConfig").build();

    private static final CreateDomainConfigurationRequestMarshaller instance = new CreateDomainConfigurationRequestMarshaller();

    public static CreateDomainConfigurationRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CreateDomainConfigurationRequest createDomainConfigurationRequest, ProtocolMarshaller protocolMarshaller) {

        if (createDomainConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(createDomainConfigurationRequest.getDomainConfigurationName(), DOMAINCONFIGURATIONNAME_BINDING);
            protocolMarshaller.marshall(createDomainConfigurationRequest.getDomainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(createDomainConfigurationRequest.getServerCertificateArns(), SERVERCERTIFICATEARNS_BINDING);
            protocolMarshaller.marshall(createDomainConfigurationRequest.getValidationCertificateArn(), VALIDATIONCERTIFICATEARN_BINDING);
            protocolMarshaller.marshall(createDomainConfigurationRequest.getAuthorizerConfig(), AUTHORIZERCONFIG_BINDING);
            protocolMarshaller.marshall(createDomainConfigurationRequest.getServiceType(), SERVICETYPE_BINDING);
            protocolMarshaller.marshall(createDomainConfigurationRequest.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(createDomainConfigurationRequest.getTlsConfig(), TLSCONFIG_BINDING);
            protocolMarshaller.marshall(createDomainConfigurationRequest.getServerCertificateConfig(), SERVERCERTIFICATECONFIG_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
