/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.internetmonitor.model.HealthEventImpactType;
import com.amazonaws.services.internetmonitor.model.HealthEventStatus;
import com.amazonaws.services.internetmonitor.model.ImpactedLocation;
import com.amazonaws.services.internetmonitor.model.transform.HealthEventMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class HealthEvent
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventArn;
    private String eventId;
    private Date startedAt;
    private Date endedAt;
    private Date createdAt;
    private Date lastUpdatedAt;
    private List<ImpactedLocation> impactedLocations;
    private String status;
    private Double percentOfTotalTrafficImpacted;
    private String impactType;
    private Double healthScoreThreshold;

    public void setEventArn(String eventArn) {
        this.eventArn = eventArn;
    }

    public String getEventArn() {
        return this.eventArn;
    }

    public HealthEvent withEventArn(String eventArn) {
        this.setEventArn(eventArn);
        return this;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public HealthEvent withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public HealthEvent withStartedAt(Date startedAt) {
        this.setStartedAt(startedAt);
        return this;
    }

    public void setEndedAt(Date endedAt) {
        this.endedAt = endedAt;
    }

    public Date getEndedAt() {
        return this.endedAt;
    }

    public HealthEvent withEndedAt(Date endedAt) {
        this.setEndedAt(endedAt);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public HealthEvent withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public HealthEvent withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public List<ImpactedLocation> getImpactedLocations() {
        return this.impactedLocations;
    }

    public void setImpactedLocations(Collection<ImpactedLocation> impactedLocations) {
        if (impactedLocations == null) {
            this.impactedLocations = null;
            return;
        }
        this.impactedLocations = new ArrayList<ImpactedLocation>(impactedLocations);
    }

    public HealthEvent withImpactedLocations(ImpactedLocation ... impactedLocations) {
        if (this.impactedLocations == null) {
            this.setImpactedLocations(new ArrayList<ImpactedLocation>(impactedLocations.length));
        }
        for (ImpactedLocation ele : impactedLocations) {
            this.impactedLocations.add(ele);
        }
        return this;
    }

    public HealthEvent withImpactedLocations(Collection<ImpactedLocation> impactedLocations) {
        this.setImpactedLocations(impactedLocations);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public HealthEvent withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public HealthEvent withStatus(HealthEventStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setPercentOfTotalTrafficImpacted(Double percentOfTotalTrafficImpacted) {
        this.percentOfTotalTrafficImpacted = percentOfTotalTrafficImpacted;
    }

    public Double getPercentOfTotalTrafficImpacted() {
        return this.percentOfTotalTrafficImpacted;
    }

    public HealthEvent withPercentOfTotalTrafficImpacted(Double percentOfTotalTrafficImpacted) {
        this.setPercentOfTotalTrafficImpacted(percentOfTotalTrafficImpacted);
        return this;
    }

    public void setImpactType(String impactType) {
        this.impactType = impactType;
    }

    public String getImpactType() {
        return this.impactType;
    }

    public HealthEvent withImpactType(String impactType) {
        this.setImpactType(impactType);
        return this;
    }

    public HealthEvent withImpactType(HealthEventImpactType impactType) {
        this.impactType = impactType.toString();
        return this;
    }

    public void setHealthScoreThreshold(Double healthScoreThreshold) {
        this.healthScoreThreshold = healthScoreThreshold;
    }

    public Double getHealthScoreThreshold() {
        return this.healthScoreThreshold;
    }

    public HealthEvent withHealthScoreThreshold(Double healthScoreThreshold) {
        this.setHealthScoreThreshold(healthScoreThreshold);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventArn() != null) {
            sb.append("EventArn: ").append(this.getEventArn()).append(",");
        }
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getStartedAt() != null) {
            sb.append("StartedAt: ").append(this.getStartedAt()).append(",");
        }
        if (this.getEndedAt() != null) {
            sb.append("EndedAt: ").append(this.getEndedAt()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getImpactedLocations() != null) {
            sb.append("ImpactedLocations: ").append(this.getImpactedLocations()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getPercentOfTotalTrafficImpacted() != null) {
            sb.append("PercentOfTotalTrafficImpacted: ").append(this.getPercentOfTotalTrafficImpacted()).append(",");
        }
        if (this.getImpactType() != null) {
            sb.append("ImpactType: ").append(this.getImpactType()).append(",");
        }
        if (this.getHealthScoreThreshold() != null) {
            sb.append("HealthScoreThreshold: ").append(this.getHealthScoreThreshold());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthEvent)) {
            return false;
        }
        HealthEvent other = (HealthEvent)obj;
        if (other.getEventArn() == null ^ this.getEventArn() == null) {
            return false;
        }
        if (other.getEventArn() != null && !other.getEventArn().equals(this.getEventArn())) {
            return false;
        }
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getStartedAt() == null ^ this.getStartedAt() == null) {
            return false;
        }
        if (other.getStartedAt() != null && !other.getStartedAt().equals(this.getStartedAt())) {
            return false;
        }
        if (other.getEndedAt() == null ^ this.getEndedAt() == null) {
            return false;
        }
        if (other.getEndedAt() != null && !other.getEndedAt().equals(this.getEndedAt())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getImpactedLocations() == null ^ this.getImpactedLocations() == null) {
            return false;
        }
        if (other.getImpactedLocations() != null && !other.getImpactedLocations().equals(this.getImpactedLocations())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPercentOfTotalTrafficImpacted() == null ^ this.getPercentOfTotalTrafficImpacted() == null) {
            return false;
        }
        if (other.getPercentOfTotalTrafficImpacted() != null && !other.getPercentOfTotalTrafficImpacted().equals(this.getPercentOfTotalTrafficImpacted())) {
            return false;
        }
        if (other.getImpactType() == null ^ this.getImpactType() == null) {
            return false;
        }
        if (other.getImpactType() != null && !other.getImpactType().equals(this.getImpactType())) {
            return false;
        }
        if (other.getHealthScoreThreshold() == null ^ this.getHealthScoreThreshold() == null) {
            return false;
        }
        return other.getHealthScoreThreshold() == null || other.getHealthScoreThreshold().equals(this.getHealthScoreThreshold());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventArn() == null ? 0 : this.getEventArn().hashCode());
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getStartedAt() == null ? 0 : this.getStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getEndedAt() == null ? 0 : this.getEndedAt().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getImpactedLocations() == null ? 0 : this.getImpactedLocations().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPercentOfTotalTrafficImpacted() == null ? 0 : this.getPercentOfTotalTrafficImpacted().hashCode());
        hashCode = 31 * hashCode + (this.getImpactType() == null ? 0 : this.getImpactType().hashCode());
        hashCode = 31 * hashCode + (this.getHealthScoreThreshold() == null ? 0 : this.getHealthScoreThreshold().hashCode());
        return hashCode;
    }

    public HealthEvent clone() {
        try {
            return (HealthEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HealthEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

