/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.inspector2.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * BatchUpdateMemberEc2DeepInspectionStatusResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchUpdateMemberEc2DeepInspectionStatusResultJsonUnmarshaller implements
        Unmarshaller<BatchUpdateMemberEc2DeepInspectionStatusResult, JsonUnmarshallerContext> {

    public BatchUpdateMemberEc2DeepInspectionStatusResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        BatchUpdateMemberEc2DeepInspectionStatusResult batchUpdateMemberEc2DeepInspectionStatusResult = new BatchUpdateMemberEc2DeepInspectionStatusResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return batchUpdateMemberEc2DeepInspectionStatusResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("accountIds", targetDepth)) {
                    context.nextToken();
                    batchUpdateMemberEc2DeepInspectionStatusResult.setAccountIds(new ListUnmarshaller<MemberAccountEc2DeepInspectionStatusState>(
                            MemberAccountEc2DeepInspectionStatusStateJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("failedAccountIds", targetDepth)) {
                    context.nextToken();
                    batchUpdateMemberEc2DeepInspectionStatusResult.setFailedAccountIds(new ListUnmarshaller<FailedMemberAccountEc2DeepInspectionStatusState>(
                            FailedMemberAccountEc2DeepInspectionStatusStateJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return batchUpdateMemberEc2DeepInspectionStatusResult;
    }

    private static BatchUpdateMemberEc2DeepInspectionStatusResultJsonUnmarshaller instance;

    public static BatchUpdateMemberEc2DeepInspectionStatusResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new BatchUpdateMemberEc2DeepInspectionStatusResultJsonUnmarshaller();
        return instance;
    }
}
