/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake Formation
 * generated authorization identifier and information from the request's authorization context.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/QuerySessionContext" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class QuerySessionContext implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * A unique identifier generated by the query engine for the query.
     * </p>
     */
    private String queryId;
    /**
     * <p>
     * A timestamp provided by the query engine for when the query started.
     * </p>
     */
    private java.util.Date queryStartTime;
    /**
     * <p>
     * An identifier string for the consumer cluster.
     * </p>
     */
    private String clusterId;
    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     */
    private String queryAuthorizationId;
    /**
     * <p>
     * An opaque string-string map passed by the query engine.
     * </p>
     */
    private java.util.Map<String, String> additionalContext;

    /**
     * <p>
     * A unique identifier generated by the query engine for the query.
     * </p>
     * 
     * @param queryId
     *        A unique identifier generated by the query engine for the query.
     */

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    /**
     * <p>
     * A unique identifier generated by the query engine for the query.
     * </p>
     * 
     * @return A unique identifier generated by the query engine for the query.
     */

    public String getQueryId() {
        return this.queryId;
    }

    /**
     * <p>
     * A unique identifier generated by the query engine for the query.
     * </p>
     * 
     * @param queryId
     *        A unique identifier generated by the query engine for the query.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QuerySessionContext withQueryId(String queryId) {
        setQueryId(queryId);
        return this;
    }

    /**
     * <p>
     * A timestamp provided by the query engine for when the query started.
     * </p>
     * 
     * @param queryStartTime
     *        A timestamp provided by the query engine for when the query started.
     */

    public void setQueryStartTime(java.util.Date queryStartTime) {
        this.queryStartTime = queryStartTime;
    }

    /**
     * <p>
     * A timestamp provided by the query engine for when the query started.
     * </p>
     * 
     * @return A timestamp provided by the query engine for when the query started.
     */

    public java.util.Date getQueryStartTime() {
        return this.queryStartTime;
    }

    /**
     * <p>
     * A timestamp provided by the query engine for when the query started.
     * </p>
     * 
     * @param queryStartTime
     *        A timestamp provided by the query engine for when the query started.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QuerySessionContext withQueryStartTime(java.util.Date queryStartTime) {
        setQueryStartTime(queryStartTime);
        return this;
    }

    /**
     * <p>
     * An identifier string for the consumer cluster.
     * </p>
     * 
     * @param clusterId
     *        An identifier string for the consumer cluster.
     */

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    /**
     * <p>
     * An identifier string for the consumer cluster.
     * </p>
     * 
     * @return An identifier string for the consumer cluster.
     */

    public String getClusterId() {
        return this.clusterId;
    }

    /**
     * <p>
     * An identifier string for the consumer cluster.
     * </p>
     * 
     * @param clusterId
     *        An identifier string for the consumer cluster.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QuerySessionContext withClusterId(String clusterId) {
        setClusterId(clusterId);
        return this;
    }

    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     * 
     * @param queryAuthorizationId
     *        A cryptographically generated query identifier generated by Glue or Lake Formation.
     */

    public void setQueryAuthorizationId(String queryAuthorizationId) {
        this.queryAuthorizationId = queryAuthorizationId;
    }

    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     * 
     * @return A cryptographically generated query identifier generated by Glue or Lake Formation.
     */

    public String getQueryAuthorizationId() {
        return this.queryAuthorizationId;
    }

    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     * 
     * @param queryAuthorizationId
     *        A cryptographically generated query identifier generated by Glue or Lake Formation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QuerySessionContext withQueryAuthorizationId(String queryAuthorizationId) {
        setQueryAuthorizationId(queryAuthorizationId);
        return this;
    }

    /**
     * <p>
     * An opaque string-string map passed by the query engine.
     * </p>
     * 
     * @return An opaque string-string map passed by the query engine.
     */

    public java.util.Map<String, String> getAdditionalContext() {
        return additionalContext;
    }

    /**
     * <p>
     * An opaque string-string map passed by the query engine.
     * </p>
     * 
     * @param additionalContext
     *        An opaque string-string map passed by the query engine.
     */

    public void setAdditionalContext(java.util.Map<String, String> additionalContext) {
        this.additionalContext = additionalContext;
    }

    /**
     * <p>
     * An opaque string-string map passed by the query engine.
     * </p>
     * 
     * @param additionalContext
     *        An opaque string-string map passed by the query engine.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QuerySessionContext withAdditionalContext(java.util.Map<String, String> additionalContext) {
        setAdditionalContext(additionalContext);
        return this;
    }

    /**
     * Add a single AdditionalContext entry
     *
     * @see QuerySessionContext#withAdditionalContext
     * @returns a reference to this object so that method calls can be chained together.
     */

    public QuerySessionContext addAdditionalContextEntry(String key, String value) {
        if (null == this.additionalContext) {
            this.additionalContext = new java.util.HashMap<String, String>();
        }
        if (this.additionalContext.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.additionalContext.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into AdditionalContext.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QuerySessionContext clearAdditionalContextEntries() {
        this.additionalContext = null;
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getQueryId() != null)
            sb.append("QueryId: ").append(getQueryId()).append(",");
        if (getQueryStartTime() != null)
            sb.append("QueryStartTime: ").append(getQueryStartTime()).append(",");
        if (getClusterId() != null)
            sb.append("ClusterId: ").append(getClusterId()).append(",");
        if (getQueryAuthorizationId() != null)
            sb.append("QueryAuthorizationId: ").append(getQueryAuthorizationId()).append(",");
        if (getAdditionalContext() != null)
            sb.append("AdditionalContext: ").append(getAdditionalContext());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof QuerySessionContext == false)
            return false;
        QuerySessionContext other = (QuerySessionContext) obj;
        if (other.getQueryId() == null ^ this.getQueryId() == null)
            return false;
        if (other.getQueryId() != null && other.getQueryId().equals(this.getQueryId()) == false)
            return false;
        if (other.getQueryStartTime() == null ^ this.getQueryStartTime() == null)
            return false;
        if (other.getQueryStartTime() != null && other.getQueryStartTime().equals(this.getQueryStartTime()) == false)
            return false;
        if (other.getClusterId() == null ^ this.getClusterId() == null)
            return false;
        if (other.getClusterId() != null && other.getClusterId().equals(this.getClusterId()) == false)
            return false;
        if (other.getQueryAuthorizationId() == null ^ this.getQueryAuthorizationId() == null)
            return false;
        if (other.getQueryAuthorizationId() != null && other.getQueryAuthorizationId().equals(this.getQueryAuthorizationId()) == false)
            return false;
        if (other.getAdditionalContext() == null ^ this.getAdditionalContext() == null)
            return false;
        if (other.getAdditionalContext() != null && other.getAdditionalContext().equals(this.getAdditionalContext()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getQueryId() == null) ? 0 : getQueryId().hashCode());
        hashCode = prime * hashCode + ((getQueryStartTime() == null) ? 0 : getQueryStartTime().hashCode());
        hashCode = prime * hashCode + ((getClusterId() == null) ? 0 : getClusterId().hashCode());
        hashCode = prime * hashCode + ((getQueryAuthorizationId() == null) ? 0 : getQueryAuthorizationId().hashCode());
        hashCode = prime * hashCode + ((getAdditionalContext() == null) ? 0 : getAdditionalContext().hashCode());
        return hashCode;
    }

    @Override
    public QuerySessionContext clone() {
        try {
            return (QuerySessionContext) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.glue.model.transform.QuerySessionContextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
