/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Option;
import com.amazonaws.services.glue.model.transform.SnowflakeNodeDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SnowflakeNodeData
implements Serializable,
Cloneable,
StructuredPojo {
    private String sourceType;
    private Option connection;
    private String schema;
    private String table;
    private String database;
    private String tempDir;
    private Option iamRole;
    private Map<String, String> additionalOptions;
    private String sampleQuery;
    private String preAction;
    private String postAction;
    private String action;
    private Boolean upsert;
    private String mergeAction;
    private String mergeWhenMatched;
    private String mergeWhenNotMatched;
    private String mergeClause;
    private String stagingTable;
    private List<Option> selectedColumns;
    private Boolean autoPushdown;
    private List<Option> tableSchema;

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public SnowflakeNodeData withSourceType(String sourceType) {
        this.setSourceType(sourceType);
        return this;
    }

    public void setConnection(Option connection) {
        this.connection = connection;
    }

    public Option getConnection() {
        return this.connection;
    }

    public SnowflakeNodeData withConnection(Option connection) {
        this.setConnection(connection);
        return this;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public SnowflakeNodeData withSchema(String schema) {
        this.setSchema(schema);
        return this;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public SnowflakeNodeData withTable(String table) {
        this.setTable(table);
        return this;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public SnowflakeNodeData withDatabase(String database) {
        this.setDatabase(database);
        return this;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public SnowflakeNodeData withTempDir(String tempDir) {
        this.setTempDir(tempDir);
        return this;
    }

    public void setIamRole(Option iamRole) {
        this.iamRole = iamRole;
    }

    public Option getIamRole() {
        return this.iamRole;
    }

    public SnowflakeNodeData withIamRole(Option iamRole) {
        this.setIamRole(iamRole);
        return this;
    }

    public Map<String, String> getAdditionalOptions() {
        return this.additionalOptions;
    }

    public void setAdditionalOptions(Map<String, String> additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public SnowflakeNodeData withAdditionalOptions(Map<String, String> additionalOptions) {
        this.setAdditionalOptions(additionalOptions);
        return this;
    }

    public SnowflakeNodeData addAdditionalOptionsEntry(String key, String value) {
        if (null == this.additionalOptions) {
            this.additionalOptions = new HashMap<String, String>();
        }
        if (this.additionalOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalOptions.put(key, value);
        return this;
    }

    public SnowflakeNodeData clearAdditionalOptionsEntries() {
        this.additionalOptions = null;
        return this;
    }

    public void setSampleQuery(String sampleQuery) {
        this.sampleQuery = sampleQuery;
    }

    public String getSampleQuery() {
        return this.sampleQuery;
    }

    public SnowflakeNodeData withSampleQuery(String sampleQuery) {
        this.setSampleQuery(sampleQuery);
        return this;
    }

    public void setPreAction(String preAction) {
        this.preAction = preAction;
    }

    public String getPreAction() {
        return this.preAction;
    }

    public SnowflakeNodeData withPreAction(String preAction) {
        this.setPreAction(preAction);
        return this;
    }

    public void setPostAction(String postAction) {
        this.postAction = postAction;
    }

    public String getPostAction() {
        return this.postAction;
    }

    public SnowflakeNodeData withPostAction(String postAction) {
        this.setPostAction(postAction);
        return this;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public SnowflakeNodeData withAction(String action) {
        this.setAction(action);
        return this;
    }

    public void setUpsert(Boolean upsert) {
        this.upsert = upsert;
    }

    public Boolean getUpsert() {
        return this.upsert;
    }

    public SnowflakeNodeData withUpsert(Boolean upsert) {
        this.setUpsert(upsert);
        return this;
    }

    public Boolean isUpsert() {
        return this.upsert;
    }

    public void setMergeAction(String mergeAction) {
        this.mergeAction = mergeAction;
    }

    public String getMergeAction() {
        return this.mergeAction;
    }

    public SnowflakeNodeData withMergeAction(String mergeAction) {
        this.setMergeAction(mergeAction);
        return this;
    }

    public void setMergeWhenMatched(String mergeWhenMatched) {
        this.mergeWhenMatched = mergeWhenMatched;
    }

    public String getMergeWhenMatched() {
        return this.mergeWhenMatched;
    }

    public SnowflakeNodeData withMergeWhenMatched(String mergeWhenMatched) {
        this.setMergeWhenMatched(mergeWhenMatched);
        return this;
    }

    public void setMergeWhenNotMatched(String mergeWhenNotMatched) {
        this.mergeWhenNotMatched = mergeWhenNotMatched;
    }

    public String getMergeWhenNotMatched() {
        return this.mergeWhenNotMatched;
    }

    public SnowflakeNodeData withMergeWhenNotMatched(String mergeWhenNotMatched) {
        this.setMergeWhenNotMatched(mergeWhenNotMatched);
        return this;
    }

    public void setMergeClause(String mergeClause) {
        this.mergeClause = mergeClause;
    }

    public String getMergeClause() {
        return this.mergeClause;
    }

    public SnowflakeNodeData withMergeClause(String mergeClause) {
        this.setMergeClause(mergeClause);
        return this;
    }

    public void setStagingTable(String stagingTable) {
        this.stagingTable = stagingTable;
    }

    public String getStagingTable() {
        return this.stagingTable;
    }

    public SnowflakeNodeData withStagingTable(String stagingTable) {
        this.setStagingTable(stagingTable);
        return this;
    }

    public List<Option> getSelectedColumns() {
        return this.selectedColumns;
    }

    public void setSelectedColumns(Collection<Option> selectedColumns) {
        if (selectedColumns == null) {
            this.selectedColumns = null;
            return;
        }
        this.selectedColumns = new ArrayList<Option>(selectedColumns);
    }

    public SnowflakeNodeData withSelectedColumns(Option ... selectedColumns) {
        if (this.selectedColumns == null) {
            this.setSelectedColumns(new ArrayList<Option>(selectedColumns.length));
        }
        for (Option ele : selectedColumns) {
            this.selectedColumns.add(ele);
        }
        return this;
    }

    public SnowflakeNodeData withSelectedColumns(Collection<Option> selectedColumns) {
        this.setSelectedColumns(selectedColumns);
        return this;
    }

    public void setAutoPushdown(Boolean autoPushdown) {
        this.autoPushdown = autoPushdown;
    }

    public Boolean getAutoPushdown() {
        return this.autoPushdown;
    }

    public SnowflakeNodeData withAutoPushdown(Boolean autoPushdown) {
        this.setAutoPushdown(autoPushdown);
        return this;
    }

    public Boolean isAutoPushdown() {
        return this.autoPushdown;
    }

    public List<Option> getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(Collection<Option> tableSchema) {
        if (tableSchema == null) {
            this.tableSchema = null;
            return;
        }
        this.tableSchema = new ArrayList<Option>(tableSchema);
    }

    public SnowflakeNodeData withTableSchema(Option ... tableSchema) {
        if (this.tableSchema == null) {
            this.setTableSchema(new ArrayList<Option>(tableSchema.length));
        }
        for (Option ele : tableSchema) {
            this.tableSchema.add(ele);
        }
        return this;
    }

    public SnowflakeNodeData withTableSchema(Collection<Option> tableSchema) {
        this.setTableSchema(tableSchema);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceType() != null) {
            sb.append("SourceType: ").append(this.getSourceType()).append(",");
        }
        if (this.getConnection() != null) {
            sb.append("Connection: ").append(this.getConnection()).append(",");
        }
        if (this.getSchema() != null) {
            sb.append("Schema: ").append(this.getSchema()).append(",");
        }
        if (this.getTable() != null) {
            sb.append("Table: ").append(this.getTable()).append(",");
        }
        if (this.getDatabase() != null) {
            sb.append("Database: ").append(this.getDatabase()).append(",");
        }
        if (this.getTempDir() != null) {
            sb.append("TempDir: ").append(this.getTempDir()).append(",");
        }
        if (this.getIamRole() != null) {
            sb.append("IamRole: ").append(this.getIamRole()).append(",");
        }
        if (this.getAdditionalOptions() != null) {
            sb.append("AdditionalOptions: ").append(this.getAdditionalOptions()).append(",");
        }
        if (this.getSampleQuery() != null) {
            sb.append("SampleQuery: ").append(this.getSampleQuery()).append(",");
        }
        if (this.getPreAction() != null) {
            sb.append("PreAction: ").append(this.getPreAction()).append(",");
        }
        if (this.getPostAction() != null) {
            sb.append("PostAction: ").append(this.getPostAction()).append(",");
        }
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getUpsert() != null) {
            sb.append("Upsert: ").append(this.getUpsert()).append(",");
        }
        if (this.getMergeAction() != null) {
            sb.append("MergeAction: ").append(this.getMergeAction()).append(",");
        }
        if (this.getMergeWhenMatched() != null) {
            sb.append("MergeWhenMatched: ").append(this.getMergeWhenMatched()).append(",");
        }
        if (this.getMergeWhenNotMatched() != null) {
            sb.append("MergeWhenNotMatched: ").append(this.getMergeWhenNotMatched()).append(",");
        }
        if (this.getMergeClause() != null) {
            sb.append("MergeClause: ").append(this.getMergeClause()).append(",");
        }
        if (this.getStagingTable() != null) {
            sb.append("StagingTable: ").append(this.getStagingTable()).append(",");
        }
        if (this.getSelectedColumns() != null) {
            sb.append("SelectedColumns: ").append(this.getSelectedColumns()).append(",");
        }
        if (this.getAutoPushdown() != null) {
            sb.append("AutoPushdown: ").append(this.getAutoPushdown()).append(",");
        }
        if (this.getTableSchema() != null) {
            sb.append("TableSchema: ").append(this.getTableSchema());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeNodeData)) {
            return false;
        }
        SnowflakeNodeData other = (SnowflakeNodeData)obj;
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        if (other.getSourceType() != null && !other.getSourceType().equals(this.getSourceType())) {
            return false;
        }
        if (other.getConnection() == null ^ this.getConnection() == null) {
            return false;
        }
        if (other.getConnection() != null && !other.getConnection().equals(this.getConnection())) {
            return false;
        }
        if (other.getSchema() == null ^ this.getSchema() == null) {
            return false;
        }
        if (other.getSchema() != null && !other.getSchema().equals(this.getSchema())) {
            return false;
        }
        if (other.getTable() == null ^ this.getTable() == null) {
            return false;
        }
        if (other.getTable() != null && !other.getTable().equals(this.getTable())) {
            return false;
        }
        if (other.getDatabase() == null ^ this.getDatabase() == null) {
            return false;
        }
        if (other.getDatabase() != null && !other.getDatabase().equals(this.getDatabase())) {
            return false;
        }
        if (other.getTempDir() == null ^ this.getTempDir() == null) {
            return false;
        }
        if (other.getTempDir() != null && !other.getTempDir().equals(this.getTempDir())) {
            return false;
        }
        if (other.getIamRole() == null ^ this.getIamRole() == null) {
            return false;
        }
        if (other.getIamRole() != null && !other.getIamRole().equals(this.getIamRole())) {
            return false;
        }
        if (other.getAdditionalOptions() == null ^ this.getAdditionalOptions() == null) {
            return false;
        }
        if (other.getAdditionalOptions() != null && !other.getAdditionalOptions().equals(this.getAdditionalOptions())) {
            return false;
        }
        if (other.getSampleQuery() == null ^ this.getSampleQuery() == null) {
            return false;
        }
        if (other.getSampleQuery() != null && !other.getSampleQuery().equals(this.getSampleQuery())) {
            return false;
        }
        if (other.getPreAction() == null ^ this.getPreAction() == null) {
            return false;
        }
        if (other.getPreAction() != null && !other.getPreAction().equals(this.getPreAction())) {
            return false;
        }
        if (other.getPostAction() == null ^ this.getPostAction() == null) {
            return false;
        }
        if (other.getPostAction() != null && !other.getPostAction().equals(this.getPostAction())) {
            return false;
        }
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getUpsert() == null ^ this.getUpsert() == null) {
            return false;
        }
        if (other.getUpsert() != null && !other.getUpsert().equals(this.getUpsert())) {
            return false;
        }
        if (other.getMergeAction() == null ^ this.getMergeAction() == null) {
            return false;
        }
        if (other.getMergeAction() != null && !other.getMergeAction().equals(this.getMergeAction())) {
            return false;
        }
        if (other.getMergeWhenMatched() == null ^ this.getMergeWhenMatched() == null) {
            return false;
        }
        if (other.getMergeWhenMatched() != null && !other.getMergeWhenMatched().equals(this.getMergeWhenMatched())) {
            return false;
        }
        if (other.getMergeWhenNotMatched() == null ^ this.getMergeWhenNotMatched() == null) {
            return false;
        }
        if (other.getMergeWhenNotMatched() != null && !other.getMergeWhenNotMatched().equals(this.getMergeWhenNotMatched())) {
            return false;
        }
        if (other.getMergeClause() == null ^ this.getMergeClause() == null) {
            return false;
        }
        if (other.getMergeClause() != null && !other.getMergeClause().equals(this.getMergeClause())) {
            return false;
        }
        if (other.getStagingTable() == null ^ this.getStagingTable() == null) {
            return false;
        }
        if (other.getStagingTable() != null && !other.getStagingTable().equals(this.getStagingTable())) {
            return false;
        }
        if (other.getSelectedColumns() == null ^ this.getSelectedColumns() == null) {
            return false;
        }
        if (other.getSelectedColumns() != null && !other.getSelectedColumns().equals(this.getSelectedColumns())) {
            return false;
        }
        if (other.getAutoPushdown() == null ^ this.getAutoPushdown() == null) {
            return false;
        }
        if (other.getAutoPushdown() != null && !other.getAutoPushdown().equals(this.getAutoPushdown())) {
            return false;
        }
        if (other.getTableSchema() == null ^ this.getTableSchema() == null) {
            return false;
        }
        return other.getTableSchema() == null || other.getTableSchema().equals(this.getTableSchema());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        hashCode = 31 * hashCode + (this.getConnection() == null ? 0 : this.getConnection().hashCode());
        hashCode = 31 * hashCode + (this.getSchema() == null ? 0 : this.getSchema().hashCode());
        hashCode = 31 * hashCode + (this.getTable() == null ? 0 : this.getTable().hashCode());
        hashCode = 31 * hashCode + (this.getDatabase() == null ? 0 : this.getDatabase().hashCode());
        hashCode = 31 * hashCode + (this.getTempDir() == null ? 0 : this.getTempDir().hashCode());
        hashCode = 31 * hashCode + (this.getIamRole() == null ? 0 : this.getIamRole().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalOptions() == null ? 0 : this.getAdditionalOptions().hashCode());
        hashCode = 31 * hashCode + (this.getSampleQuery() == null ? 0 : this.getSampleQuery().hashCode());
        hashCode = 31 * hashCode + (this.getPreAction() == null ? 0 : this.getPreAction().hashCode());
        hashCode = 31 * hashCode + (this.getPostAction() == null ? 0 : this.getPostAction().hashCode());
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getUpsert() == null ? 0 : this.getUpsert().hashCode());
        hashCode = 31 * hashCode + (this.getMergeAction() == null ? 0 : this.getMergeAction().hashCode());
        hashCode = 31 * hashCode + (this.getMergeWhenMatched() == null ? 0 : this.getMergeWhenMatched().hashCode());
        hashCode = 31 * hashCode + (this.getMergeWhenNotMatched() == null ? 0 : this.getMergeWhenNotMatched().hashCode());
        hashCode = 31 * hashCode + (this.getMergeClause() == null ? 0 : this.getMergeClause().hashCode());
        hashCode = 31 * hashCode + (this.getStagingTable() == null ? 0 : this.getStagingTable().hashCode());
        hashCode = 31 * hashCode + (this.getSelectedColumns() == null ? 0 : this.getSelectedColumns().hashCode());
        hashCode = 31 * hashCode + (this.getAutoPushdown() == null ? 0 : this.getAutoPushdown().hashCode());
        hashCode = 31 * hashCode + (this.getTableSchema() == null ? 0 : this.getTableSchema().hashCode());
        return hashCode;
    }

    public SnowflakeNodeData clone() {
        try {
            return (SnowflakeNodeData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnowflakeNodeDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

