/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.IngestedEventStatistics;

@SdkInternalApi
public class IngestedEventStatisticsMarshaller {
    private static final MarshallingInfo<Long> NUMBEROFEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfEvents").build();
    private static final MarshallingInfo<Long> EVENTDATASIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventDataSizeInBytes").build();
    private static final MarshallingInfo<String> LEASTRECENTEVENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("leastRecentEvent").build();
    private static final MarshallingInfo<String> MOSTRECENTEVENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mostRecentEvent").build();
    private static final MarshallingInfo<String> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").build();
    private static final IngestedEventStatisticsMarshaller instance = new IngestedEventStatisticsMarshaller();

    public static IngestedEventStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(IngestedEventStatistics ingestedEventStatistics, ProtocolMarshaller protocolMarshaller) {
        if (ingestedEventStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ingestedEventStatistics.getNumberOfEvents(), NUMBEROFEVENTS_BINDING);
            protocolMarshaller.marshall((Object)ingestedEventStatistics.getEventDataSizeInBytes(), EVENTDATASIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)ingestedEventStatistics.getLeastRecentEvent(), LEASTRECENTEVENT_BINDING);
            protocolMarshaller.marshall((Object)ingestedEventStatistics.getMostRecentEvent(), MOSTRECENTEVENT_BINDING);
            protocolMarshaller.marshall((Object)ingestedEventStatistics.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

