/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.waiters.AnyInstanceInService;
import com.amazonaws.services.elasticloadbalancing.waiters.DescribeInstanceHealthFunction;
import com.amazonaws.services.elasticloadbalancing.waiters.InstanceDeregistered;
import com.amazonaws.services.elasticloadbalancing.waiters.InstanceInService;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonElasticLoadBalancingWaiters {
    private final AmazonElasticLoadBalancing client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonElasticLoadBalancingWaiters");

    @SdkInternalApi
    public AmazonElasticLoadBalancingWaiters(AmazonElasticLoadBalancing client) {
        this.client = client;
    }

    public Waiter<DescribeInstanceHealthRequest> anyInstanceInService() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceHealthFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AnyInstanceInService.IsInServiceMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstanceHealthRequest> instanceDeregistered() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceHealthFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceDeregistered.IsOutOfServiceMatcher(), new InstanceDeregistered.IsInvalidInstanceMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstanceHealthRequest> instanceInService() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceHealthFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceInService.IsInServiceMatcher(), new InstanceInService.IsInvalidInstanceMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

