/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.RegionalConfiguration;
import com.amazonaws.services.elasticache.model.ReshardingConfiguration;
import com.amazonaws.services.elasticache.model.transform.ReshardingConfigurationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class RegionalConfigurationStaxUnmarshaller
implements Unmarshaller<RegionalConfiguration, StaxUnmarshallerContext> {
    private static RegionalConfigurationStaxUnmarshaller instance;

    public RegionalConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        RegionalConfiguration regionalConfiguration = new RegionalConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return regionalConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ReplicationGroupId", targetDepth)) {
                    regionalConfiguration.setReplicationGroupId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicationGroupRegion", targetDepth)) {
                    regionalConfiguration.setReplicationGroupRegion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReshardingConfiguration", targetDepth)) {
                    regionalConfiguration.withReshardingConfiguration(new ArrayList<ReshardingConfiguration>());
                    continue;
                }
                if (!context.testExpression("ReshardingConfiguration/ReshardingConfiguration", targetDepth)) continue;
                regionalConfiguration.withReshardingConfiguration(ReshardingConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return regionalConfiguration;
    }

    public static RegionalConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RegionalConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

