/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datazone.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostTimeSeriesDataPoints" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PostTimeSeriesDataPointsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The ID of the Amazon DataZone domain in which you want to post time series data points.
     * </p>
     */
    private String domainIdentifier;
    /**
     * <p>
     * The ID of the asset for which you want to post time series data points.
     * </p>
     */
    private String entityIdentifier;
    /**
     * <p>
     * The type of the asset for which you want to post data points.
     * </p>
     */
    private String entityType;
    /**
     * <p>
     * The forms that contain the data points that you want to post.
     * </p>
     */
    private java.util.List<TimeSeriesDataPointFormInput> forms;

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PostTimeSeriesDataPointsRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which you want to post time series data points.
     * </p>
     * 
     * @param domainIdentifier
     *        The ID of the Amazon DataZone domain in which you want to post time series data points.
     */

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which you want to post time series data points.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which you want to post time series data points.
     */

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which you want to post time series data points.
     * </p>
     * 
     * @param domainIdentifier
     *        The ID of the Amazon DataZone domain in which you want to post time series data points.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PostTimeSeriesDataPointsRequest withDomainIdentifier(String domainIdentifier) {
        setDomainIdentifier(domainIdentifier);
        return this;
    }

    /**
     * <p>
     * The ID of the asset for which you want to post time series data points.
     * </p>
     * 
     * @param entityIdentifier
     *        The ID of the asset for which you want to post time series data points.
     */

    public void setEntityIdentifier(String entityIdentifier) {
        this.entityIdentifier = entityIdentifier;
    }

    /**
     * <p>
     * The ID of the asset for which you want to post time series data points.
     * </p>
     * 
     * @return The ID of the asset for which you want to post time series data points.
     */

    public String getEntityIdentifier() {
        return this.entityIdentifier;
    }

    /**
     * <p>
     * The ID of the asset for which you want to post time series data points.
     * </p>
     * 
     * @param entityIdentifier
     *        The ID of the asset for which you want to post time series data points.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PostTimeSeriesDataPointsRequest withEntityIdentifier(String entityIdentifier) {
        setEntityIdentifier(entityIdentifier);
        return this;
    }

    /**
     * <p>
     * The type of the asset for which you want to post data points.
     * </p>
     * 
     * @param entityType
     *        The type of the asset for which you want to post data points.
     * @see TimeSeriesEntityType
     */

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    /**
     * <p>
     * The type of the asset for which you want to post data points.
     * </p>
     * 
     * @return The type of the asset for which you want to post data points.
     * @see TimeSeriesEntityType
     */

    public String getEntityType() {
        return this.entityType;
    }

    /**
     * <p>
     * The type of the asset for which you want to post data points.
     * </p>
     * 
     * @param entityType
     *        The type of the asset for which you want to post data points.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TimeSeriesEntityType
     */

    public PostTimeSeriesDataPointsRequest withEntityType(String entityType) {
        setEntityType(entityType);
        return this;
    }

    /**
     * <p>
     * The type of the asset for which you want to post data points.
     * </p>
     * 
     * @param entityType
     *        The type of the asset for which you want to post data points.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TimeSeriesEntityType
     */

    public PostTimeSeriesDataPointsRequest withEntityType(TimeSeriesEntityType entityType) {
        this.entityType = entityType.toString();
        return this;
    }

    /**
     * <p>
     * The forms that contain the data points that you want to post.
     * </p>
     * 
     * @return The forms that contain the data points that you want to post.
     */

    public java.util.List<TimeSeriesDataPointFormInput> getForms() {
        return forms;
    }

    /**
     * <p>
     * The forms that contain the data points that you want to post.
     * </p>
     * 
     * @param forms
     *        The forms that contain the data points that you want to post.
     */

    public void setForms(java.util.Collection<TimeSeriesDataPointFormInput> forms) {
        if (forms == null) {
            this.forms = null;
            return;
        }

        this.forms = new java.util.ArrayList<TimeSeriesDataPointFormInput>(forms);
    }

    /**
     * <p>
     * The forms that contain the data points that you want to post.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setForms(java.util.Collection)} or {@link #withForms(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param forms
     *        The forms that contain the data points that you want to post.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PostTimeSeriesDataPointsRequest withForms(TimeSeriesDataPointFormInput... forms) {
        if (this.forms == null) {
            setForms(new java.util.ArrayList<TimeSeriesDataPointFormInput>(forms.length));
        }
        for (TimeSeriesDataPointFormInput ele : forms) {
            this.forms.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The forms that contain the data points that you want to post.
     * </p>
     * 
     * @param forms
     *        The forms that contain the data points that you want to post.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PostTimeSeriesDataPointsRequest withForms(java.util.Collection<TimeSeriesDataPointFormInput> forms) {
        setForms(forms);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getDomainIdentifier() != null)
            sb.append("DomainIdentifier: ").append(getDomainIdentifier()).append(",");
        if (getEntityIdentifier() != null)
            sb.append("EntityIdentifier: ").append(getEntityIdentifier()).append(",");
        if (getEntityType() != null)
            sb.append("EntityType: ").append(getEntityType()).append(",");
        if (getForms() != null)
            sb.append("Forms: ").append(getForms());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PostTimeSeriesDataPointsRequest == false)
            return false;
        PostTimeSeriesDataPointsRequest other = (PostTimeSeriesDataPointsRequest) obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null)
            return false;
        if (other.getDomainIdentifier() != null && other.getDomainIdentifier().equals(this.getDomainIdentifier()) == false)
            return false;
        if (other.getEntityIdentifier() == null ^ this.getEntityIdentifier() == null)
            return false;
        if (other.getEntityIdentifier() != null && other.getEntityIdentifier().equals(this.getEntityIdentifier()) == false)
            return false;
        if (other.getEntityType() == null ^ this.getEntityType() == null)
            return false;
        if (other.getEntityType() != null && other.getEntityType().equals(this.getEntityType()) == false)
            return false;
        if (other.getForms() == null ^ this.getForms() == null)
            return false;
        if (other.getForms() != null && other.getForms().equals(this.getForms()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getDomainIdentifier() == null) ? 0 : getDomainIdentifier().hashCode());
        hashCode = prime * hashCode + ((getEntityIdentifier() == null) ? 0 : getEntityIdentifier().hashCode());
        hashCode = prime * hashCode + ((getEntityType() == null) ? 0 : getEntityType().hashCode());
        hashCode = prime * hashCode + ((getForms() == null) ? 0 : getForms().hashCode());
        return hashCode;
    }

    @Override
    public PostTimeSeriesDataPointsRequest clone() {
        return (PostTimeSeriesDataPointsRequest) super.clone();
    }

}
