/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.comprehend.model.DocumentMetadata;
import java.util.List;

@SdkInternalApi
public class DocumentMetadataMarshaller {
    private static final MarshallingInfo<Integer> PAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pages").build();
    private static final MarshallingInfo<List> EXTRACTEDCHARACTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtractedCharacters").build();
    private static final DocumentMetadataMarshaller instance = new DocumentMetadataMarshaller();

    public static DocumentMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentMetadata documentMetadata, ProtocolMarshaller protocolMarshaller) {
        if (documentMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentMetadata.getPages(), PAGES_BINDING);
            protocolMarshaller.marshall(documentMetadata.getExtractedCharacters(), EXTRACTEDCHARACTERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

