/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codegurusecurity.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.codegurusecurity.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * MetricsSummaryMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class MetricsSummaryMarshaller {

    private static final MarshallingInfo<List> CATEGORIESWITHMOSTFINDINGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("categoriesWithMostFindings").build();
    private static final MarshallingInfo<java.util.Date> DATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("date").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> OPENFINDINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("openFindings").build();
    private static final MarshallingInfo<List> SCANSWITHMOSTOPENCRITICALFINDINGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scansWithMostOpenCriticalFindings").build();
    private static final MarshallingInfo<List> SCANSWITHMOSTOPENFINDINGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scansWithMostOpenFindings").build();

    private static final MetricsSummaryMarshaller instance = new MetricsSummaryMarshaller();

    public static MetricsSummaryMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(MetricsSummary metricsSummary, ProtocolMarshaller protocolMarshaller) {

        if (metricsSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(metricsSummary.getCategoriesWithMostFindings(), CATEGORIESWITHMOSTFINDINGS_BINDING);
            protocolMarshaller.marshall(metricsSummary.getDate(), DATE_BINDING);
            protocolMarshaller.marshall(metricsSummary.getOpenFindings(), OPENFINDINGS_BINDING);
            protocolMarshaller.marshall(metricsSummary.getScansWithMostOpenCriticalFindings(), SCANSWITHMOSTOPENCRITICALFINDINGS_BINDING);
            protocolMarshaller.marshall(metricsSummary.getScansWithMostOpenFindings(), SCANSWITHMOSTOPENFINDINGS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
