/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.amplifyuibuilder.model.transform;

import java.util.Map;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.amplifyuibuilder.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ReactStartCodegenJobDataMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ReactStartCodegenJobDataMarshaller {

    private static final MarshallingInfo<String> MODULE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("module").build();
    private static final MarshallingInfo<String> TARGET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("target").build();
    private static final MarshallingInfo<String> SCRIPT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("script").build();
    private static final MarshallingInfo<Boolean> RENDERTYPEDECLARATIONS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("renderTypeDeclarations").build();
    private static final MarshallingInfo<Boolean> INLINESOURCEMAP_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inlineSourceMap").build();
    private static final MarshallingInfo<StructuredPojo> APICONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiConfiguration").build();
    private static final MarshallingInfo<Map> DEPENDENCIES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("dependencies").build();

    private static final ReactStartCodegenJobDataMarshaller instance = new ReactStartCodegenJobDataMarshaller();

    public static ReactStartCodegenJobDataMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ReactStartCodegenJobData reactStartCodegenJobData, ProtocolMarshaller protocolMarshaller) {

        if (reactStartCodegenJobData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(reactStartCodegenJobData.getModule(), MODULE_BINDING);
            protocolMarshaller.marshall(reactStartCodegenJobData.getTarget(), TARGET_BINDING);
            protocolMarshaller.marshall(reactStartCodegenJobData.getScript(), SCRIPT_BINDING);
            protocolMarshaller.marshall(reactStartCodegenJobData.getRenderTypeDeclarations(), RENDERTYPEDECLARATIONS_BINDING);
            protocolMarshaller.marshall(reactStartCodegenJobData.getInlineSourceMap(), INLINESOURCEMAP_BINDING);
            protocolMarshaller.marshall(reactStartCodegenJobData.getApiConfiguration(), APICONFIGURATION_BINDING);
            protocolMarshaller.marshall(reactStartCodegenJobData.getDependencies(), DEPENDENCIES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
