/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.release.versions.VersionInfo;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="hotfix-finish", aggregator=true)
public class GitFlowHotfixFinishMojo
extends AbstractGitFlowMojo {
    @Parameter(property="skipTag", defaultValue="false")
    private boolean skipTag = false;
    @Parameter(property="keepBranch", defaultValue="false")
    private boolean keepBranch = false;
    @Parameter(property="skipTestProject", defaultValue="false")
    private boolean skipTestProject = false;
    @Parameter(property="pushRemote", defaultValue="true")
    private boolean pushRemote;
    @Parameter(property="preHotfixGoals")
    private String preHotfixGoals;
    @Parameter(property="postHotfixGoals")
    private String postHotfixGoals;
    @Parameter(property="hotfixVersion")
    private String hotfixVersion;
    @Parameter(property="hotfixBranch")
    private String hotfixBranch;
    @Parameter(property="gpgSignTag", defaultValue="false")
    private boolean gpgSignTag = false;
    @Parameter(property="useSnapshotInHotfix", defaultValue="false")
    private boolean useSnapshotInHotfix;
    @Parameter(property="skipMergeProdBranch", defaultValue="false")
    private boolean skipMergeProdBranch = false;
    @Parameter(property="skipMergeDevBranch", defaultValue="false")
    private boolean skipMergeDevBranch = false;
    @Parameter(property="noBackMergeHotfix", defaultValue="false")
    private boolean noBackMergeHotfix = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(this.preHotfixGoals, this.postHotfixGoals);
        try {
            String tagVersion;
            this.checkUncommittedChanges();
            String hotfixBranchName = null;
            if (this.settings.isInteractiveMode()) {
                hotfixBranchName = this.promptBranchName();
            } else if (StringUtils.isNotBlank((String)this.hotfixBranch)) {
                if (!this.hotfixBranch.startsWith(this.gitFlowConfig.getHotfixBranchPrefix())) {
                    throw new MojoFailureException("The hotfixBranch parameter doesn't start with hotfix branch prefix.");
                }
                if (!this.gitCheckBranchExists(this.hotfixBranch)) {
                    throw new MojoFailureException("Hotfix branch with name '" + this.hotfixBranch + "' doesn't exist. Cannot finish hotfix.");
                }
                hotfixBranchName = this.hotfixBranch;
            } else if (StringUtils.isNotBlank((String)this.hotfixVersion)) {
                String branch = this.gitFlowConfig.getHotfixBranchPrefix() + this.hotfixVersion;
                if (!this.gitCheckBranchExists(branch)) {
                    throw new MojoFailureException("Hotfix branch with name '" + branch + "' doesn't exist. Cannot finish hotfix.");
                }
                hotfixBranchName = branch;
            }
            if (StringUtils.isBlank((String)hotfixBranchName)) {
                throw new MojoFailureException("Hotfix branch name to finish is blank.");
            }
            String supportBranchName = null;
            boolean supportHotfix = hotfixBranchName.startsWith(this.gitFlowConfig.getHotfixBranchPrefix() + this.gitFlowConfig.getSupportBranchPrefix());
            if (supportHotfix) {
                supportBranchName = hotfixBranchName.substring(this.gitFlowConfig.getHotfixBranchPrefix().length());
                supportBranchName = supportBranchName.substring(0, supportBranchName.lastIndexOf(47));
            }
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCompare(hotfixBranchName);
                if (supportBranchName != null) {
                    this.gitFetchRemoteAndCreate(supportBranchName);
                    this.gitFetchRemoteAndCompare(supportBranchName);
                } else {
                    if (this.notSameProdDevName()) {
                        this.gitFetchRemoteAndCreate(this.gitFlowConfig.getDevelopmentBranch());
                        this.gitFetchRemoteAndCompare(this.gitFlowConfig.getDevelopmentBranch());
                    }
                    this.gitFetchRemoteAndCreate(this.gitFlowConfig.getProductionBranch());
                    this.gitFetchRemoteAndCompare(this.gitFlowConfig.getProductionBranch());
                }
            }
            this.gitCheckout(hotfixBranchName);
            if (!this.skipTestProject) {
                this.mvnCleanTest();
            }
            if (StringUtils.isNotBlank((String)this.preHotfixGoals)) {
                this.mvnRun(this.preHotfixGoals);
            }
            String currentHotfixVersion = this.getCurrentProjectVersion();
            HashMap<String, String> messageProperties = new HashMap<String, String>();
            messageProperties.put("version", currentHotfixVersion);
            if (this.useSnapshotInHotfix && ArtifactUtils.isSnapshot((String)currentHotfixVersion)) {
                String commitVersion = currentHotfixVersion.replace("-SNAPSHOT", "");
                this.mvnSetVersions(commitVersion);
                messageProperties.put("version", commitVersion);
                this.gitCommit(this.commitMessages.getHotfixFinishMessage(), messageProperties);
            }
            if (supportBranchName != null) {
                this.gitCheckout(supportBranchName);
                this.gitMergeNoff(hotfixBranchName, this.commitMessages.getHotfixFinishSupportMergeMessage(), messageProperties);
            } else if (!this.skipMergeProdBranch) {
                this.gitCheckout(this.gitFlowConfig.getProductionBranch());
                this.gitMergeNoff(hotfixBranchName, this.commitMessages.getHotfixFinishMergeMessage(), messageProperties);
            }
            String currentVersion = this.getCurrentProjectVersion();
            String string = tagVersion = (this.tychoBuild || this.useSnapshotInHotfix) && ArtifactUtils.isSnapshot((String)currentVersion) ? currentVersion.replace("-SNAPSHOT", "") : currentVersion;
            if (!this.skipTag) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("version", tagVersion);
                this.gitTag(this.gitFlowConfig.getVersionTagPrefix() + tagVersion, this.commitMessages.getTagHotfixMessage(), this.gpgSignTag, properties);
            }
            if (this.skipMergeProdBranch && supportBranchName == null) {
                this.gitCheckout(this.gitFlowConfig.getProductionBranch());
            }
            if (StringUtils.isNotBlank((String)this.postHotfixGoals)) {
                this.mvnRun(this.postHotfixGoals);
            }
            String releaseBranch = this.gitFindBranches(this.gitFlowConfig.getReleaseBranchPrefix(), true);
            if (supportBranchName == null) {
                if (StringUtils.isNotBlank((String)releaseBranch)) {
                    this.gitCheckout(releaseBranch);
                    String releaseBranchVersion = this.getCurrentProjectVersion();
                    if (!currentVersion.equals(releaseBranchVersion)) {
                        this.mvnSetVersions(currentVersion);
                        this.gitCommit(this.commitMessages.getUpdateReleaseToAvoidConflictsMessage());
                    }
                    messageProperties.put("version", currentVersion);
                    this.gitMergeNoff(hotfixBranchName, this.commitMessages.getHotfixFinishReleaseMergeMessage(), messageProperties);
                    if (!currentVersion.equals(releaseBranchVersion)) {
                        this.mvnSetVersions(releaseBranchVersion);
                        this.gitCommit(this.commitMessages.getUpdateReleaseBackPreMergeStateMessage());
                    }
                } else if (!this.skipMergeDevBranch) {
                    String nextSnapshotVersion;
                    GitFlowVersionInfo developVersionInfo = new GitFlowVersionInfo(currentVersion, this.getVersionPolicy());
                    if (this.notSameProdDevName()) {
                        this.gitCheckout(this.gitFlowConfig.getDevelopmentBranch());
                        developVersionInfo = new GitFlowVersionInfo(this.getCurrentProjectVersion(), this.getVersionPolicy());
                        this.mvnSetVersions(currentVersion);
                        this.gitCommit(this.commitMessages.getHotfixVersionUpdateMessage());
                        messageProperties.put("version", currentVersion);
                        String refToMerge = this.skipMergeProdBranch || this.noBackMergeHotfix ? hotfixBranchName : (!this.skipTag ? this.gitFlowConfig.getVersionTagPrefix() + tagVersion : this.gitFlowConfig.getProductionBranch());
                        this.gitMergeNoff(refToMerge, this.commitMessages.getHotfixFinishDevMergeMessage(), messageProperties);
                        GitFlowVersionInfo hotfixVersionInfo = new GitFlowVersionInfo(currentVersion, this.getVersionPolicy());
                        if (developVersionInfo.compareTo((VersionInfo)hotfixVersionInfo) < 0) {
                            developVersionInfo = hotfixVersionInfo;
                        }
                    }
                    if (StringUtils.isBlank((String)(nextSnapshotVersion = developVersionInfo.getSnapshotVersionString()))) {
                        throw new MojoFailureException("Next snapshot version is blank.");
                    }
                    this.mvnSetVersions(nextSnapshotVersion);
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("version", nextSnapshotVersion);
                    this.gitCommit(this.commitMessages.getHotfixFinishMessage(), properties);
                }
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.pushRemote) {
                if (supportBranchName != null) {
                    this.gitPush(supportBranchName, !this.skipTag);
                } else {
                    this.gitPush(this.gitFlowConfig.getProductionBranch(), !this.skipTag);
                    if (StringUtils.isNotBlank((String)releaseBranch)) {
                        this.gitPush(releaseBranch, !this.skipTag);
                    } else if (StringUtils.isBlank((String)releaseBranch) && this.notSameProdDevName()) {
                        this.gitPush(this.gitFlowConfig.getDevelopmentBranch(), !this.skipTag);
                    }
                }
                if (!this.keepBranch) {
                    this.gitPushDelete(hotfixBranchName);
                }
            }
            if (!this.keepBranch) {
                if (this.skipMergeProdBranch) {
                    this.gitBranchDeleteForce(hotfixBranchName);
                } else {
                    this.gitBranchDelete(hotfixBranchName);
                }
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("hotfix-finish", (Throwable)e);
        }
    }

    private String promptBranchName() throws MojoFailureException, CommandLineException {
        String hotfixBranches = this.gitFindBranches(this.gitFlowConfig.getHotfixBranchPrefix(), false);
        if (!this.gitFlowConfig.getHotfixBranchPrefix().endsWith("/")) {
            String supportHotfixBranches = this.gitFindBranches(this.gitFlowConfig.getHotfixBranchPrefix() + "*/*", false);
            hotfixBranches = hotfixBranches + supportHotfixBranches;
        }
        if (StringUtils.isBlank((String)hotfixBranches)) {
            throw new MojoFailureException("There are no hotfix branches.");
        }
        String[] branches = hotfixBranches.split("\\r?\\n");
        ArrayList<String> numberedList = new ArrayList<String>();
        StringBuilder str = new StringBuilder("Hotfix branches:").append(LS);
        for (int i = 0; i < branches.length; ++i) {
            str.append(i + 1 + ". " + branches[i] + LS);
            numberedList.add(String.valueOf(i + 1));
        }
        str.append("Choose hotfix branch to finish");
        String hotfixNumber = null;
        try {
            while (StringUtils.isBlank(hotfixNumber)) {
                hotfixNumber = this.prompter.prompt(str.toString(), numberedList);
            }
        }
        catch (PrompterException e) {
            throw new MojoFailureException("hotfix-finish", (Throwable)e);
        }
        String hotfixBranchName = null;
        if (hotfixNumber != null) {
            int num = Integer.parseInt(hotfixNumber);
            hotfixBranchName = branches[num - 1];
        }
        return hotfixBranchName;
    }
}

