/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.comment;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.comment.AbstractAliCommentRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class ClassMustHaveAuthorRule
extends AbstractAliCommentRule {
    private static final Pattern AUTHOR_PATTERN = Pattern.compile(".*@[Aa]uthor.*", 34);
    private static final String MESSAGE_KEY_PREFIX = "java.comment.ClassMustHaveAuthorRule.violation.msg";

    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        if (decl.isPublic()) {
            this.checkAuthorComment((AbstractJavaNode)decl, data);
        }
        return data;
    }

    public Object visit(ASTEnumDeclaration decl, Object data) {
        if (!decl.isPublic()) {
            return super.visit(decl, data);
        }
        ASTClassOrInterfaceDeclaration parent = (ASTClassOrInterfaceDeclaration)decl.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        if (parent != null) {
            return super.visit(decl, data);
        }
        this.checkAuthorComment((AbstractJavaNode)decl, data);
        return data;
    }

    public Object visit(ASTAnnotationTypeDeclaration decl, Object data) {
        this.checkAuthorComment((AbstractJavaNode)decl, data);
        return data;
    }

    public Object visit(ASTCompilationUnit cUnit, Object data) {
        this.assignCommentsToDeclarations(cUnit);
        return super.visit(cUnit, data);
    }

    protected SortedMap<Integer, Node> orderedCommentsAndDeclarations(ASTCompilationUnit cUnit) {
        TreeMap<Integer, Node> itemsByLineNumber = new TreeMap<Integer, Node>();
        List packageDecl = cUnit.findDescendantsOfType(ASTClassOrInterfaceDeclaration.class);
        this.addDeclarations(itemsByLineNumber, packageDecl);
        List enumDecl = cUnit.findDescendantsOfType(ASTEnumDeclaration.class);
        this.addDeclarations(itemsByLineNumber, enumDecl);
        List annotationDecl = cUnit.findDescendantsOfType(ASTAnnotationTypeDeclaration.class);
        this.addDeclarations(itemsByLineNumber, annotationDecl);
        this.addDeclarations(itemsByLineNumber, cUnit.getComments());
        return itemsByLineNumber;
    }

    private void addDeclarations(SortedMap<Integer, Node> map, List<? extends Node> nodes) {
        for (Node node : nodes) {
            map.put((node.getBeginLine() << 16) + node.getBeginColumn(), node);
        }
    }

    public void checkAuthorComment(AbstractJavaNode decl, Object data) {
        Comment comment = decl.comment();
        if (null == comment) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)decl, data, I18nResources.getMessage("java.comment.ClassMustHaveAuthorRule.violation.msg.comment", decl.getImage()));
        } else {
            String commentContent = comment.getImage();
            boolean hasAuthor = AUTHOR_PATTERN.matcher(commentContent).matches();
            if (!hasAuthor) {
                ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)decl, data, I18nResources.getMessage("java.comment.ClassMustHaveAuthorRule.violation.msg.author", decl.getImage()));
            }
        }
    }
}

