/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.metrics;

import java.util.concurrent.atomic.AtomicBoolean;

public class Instrumentation {
    private final String name;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected Exception startException = null;

    public Instrumentation(String name) {
        this.name = name;
    }

    public boolean isDown() {
        return this.startException != null;
    }

    public boolean isUp() {
        return this.started.get();
    }

    public boolean isOutOfService() {
        return !this.started.get() && this.startException == null;
    }

    public void markStartedSuccessfully() {
        this.started.set(true);
    }

    public void markStartFailed(Exception e) {
        this.started.set(false);
        this.startException = e;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public Exception getStartException() {
        return this.startException;
    }
}

