/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetPrivilegesResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetPrivilegesRequest
extends RequestBase {
    @Nullable
    private final String application;
    @Nullable
    private final String name;
    public static final Endpoint<GetPrivilegesRequest, GetPrivilegesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetPrivilegesRequest, GetPrivilegesResponse>("es/security.get_privileges", request -> "GET", request -> {
        boolean _application = true;
        int _name = 2;
        int propsSet = 0;
        if (request.application() != null) {
            propsSet |= 1;
        }
        if (request.name() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.application, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.application, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetPrivilegesResponse._DESERIALIZER);

    private GetPrivilegesRequest(Builder builder) {
        this.application = builder.application;
        this.name = builder.name;
    }

    public static GetPrivilegesRequest of(Function<Builder, ObjectBuilder<GetPrivilegesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String application() {
        return this.application;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetPrivilegesRequest> {
        @Nullable
        private String application;
        @Nullable
        private String name;

        public final Builder application(@Nullable String value) {
            this.application = value;
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetPrivilegesRequest build() {
            this._checkSingleUse();
            return new GetPrivilegesRequest(this);
        }
    }
}

