/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.GetOverallBucketsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetOverallBucketsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoJobs;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Time bucketSpan;
    @Nullable
    private final Time end;
    @Nullable
    private final Boolean excludeInterim;
    private final String jobId;
    @Nullable
    private final String overallScore;
    @Nullable
    private final Time start;
    @Nullable
    private final Integer topN;
    public static final JsonpDeserializer<GetOverallBucketsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetOverallBucketsRequest::setupGetOverallBucketsRequestDeserializer);
    public static final Endpoint<GetOverallBucketsRequest, GetOverallBucketsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetOverallBucketsRequest, GetOverallBucketsResponse>("es/ml.get_overall_buckets", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/overall_buckets");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, GetOverallBucketsResponse._DESERIALIZER);

    private GetOverallBucketsRequest(Builder builder) {
        this.allowNoJobs = builder.allowNoJobs;
        this.allowNoMatch = builder.allowNoMatch;
        this.bucketSpan = builder.bucketSpan;
        this.end = builder.end;
        this.excludeInterim = builder.excludeInterim;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.overallScore = builder.overallScore;
        this.start = builder.start;
        this.topN = builder.topN;
    }

    public static GetOverallBucketsRequest of(Function<Builder, ObjectBuilder<GetOverallBucketsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Deprecated
    @Nullable
    public final Boolean allowNoJobs() {
        return this.allowNoJobs;
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Time bucketSpan() {
        return this.bucketSpan;
    }

    @Nullable
    public final Time end() {
        return this.end;
    }

    @Nullable
    public final Boolean excludeInterim() {
        return this.excludeInterim;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final String overallScore() {
        return this.overallScore;
    }

    @Nullable
    public final Time start() {
        return this.start;
    }

    @Nullable
    public final Integer topN() {
        return this.topN;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowNoJobs != null) {
            generator.writeKey("allow_no_jobs");
            generator.write(this.allowNoJobs.booleanValue());
        }
        if (this.allowNoMatch != null) {
            generator.writeKey("allow_no_match");
            generator.write(this.allowNoMatch.booleanValue());
        }
        if (this.bucketSpan != null) {
            generator.writeKey("bucket_span");
            this.bucketSpan.serialize(generator, mapper);
        }
        if (this.end != null) {
            generator.writeKey("end");
            this.end.serialize(generator, mapper);
        }
        if (this.excludeInterim != null) {
            generator.writeKey("exclude_interim");
            generator.write(this.excludeInterim.booleanValue());
        }
        if (this.overallScore != null) {
            generator.writeKey("overall_score");
            generator.write(this.overallScore);
        }
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
        if (this.topN != null) {
            generator.writeKey("top_n");
            generator.write(this.topN.intValue());
        }
    }

    protected static void setupGetOverallBucketsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowNoJobs, JsonpDeserializer.booleanDeserializer(), "allow_no_jobs");
        op.add(Builder::allowNoMatch, JsonpDeserializer.booleanDeserializer(), "allow_no_match");
        op.add(Builder::bucketSpan, Time._DESERIALIZER, "bucket_span");
        op.add(Builder::end, Time._DESERIALIZER, "end");
        op.add(Builder::excludeInterim, JsonpDeserializer.booleanDeserializer(), "exclude_interim");
        op.add(Builder::overallScore, JsonpDeserializer.stringDeserializer(), "overall_score");
        op.add(Builder::start, Time._DESERIALIZER, "start");
        op.add(Builder::topN, JsonpDeserializer.integerDeserializer(), "top_n");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetOverallBucketsRequest> {
        @Nullable
        private Boolean allowNoJobs;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Time bucketSpan;
        @Nullable
        private Time end;
        @Nullable
        private Boolean excludeInterim;
        private String jobId;
        @Nullable
        private String overallScore;
        @Nullable
        private Time start;
        @Nullable
        private Integer topN;

        @Deprecated
        public final Builder allowNoJobs(@Nullable Boolean value) {
            this.allowNoJobs = value;
            return this;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder bucketSpan(@Nullable Time value) {
            this.bucketSpan = value;
            return this;
        }

        public final Builder bucketSpan(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.bucketSpan(fn.apply(new Time.Builder()).build());
        }

        public final Builder end(@Nullable Time value) {
            this.end = value;
            return this;
        }

        public final Builder end(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.end(fn.apply(new Time.Builder()).build());
        }

        public final Builder excludeInterim(@Nullable Boolean value) {
            this.excludeInterim = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder overallScore(@Nullable String value) {
            this.overallScore = value;
            return this;
        }

        public final Builder start(@Nullable Time value) {
            this.start = value;
            return this;
        }

        public final Builder start(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.start(fn.apply(new Time.Builder()).build());
        }

        public final Builder topN(@Nullable Integer value) {
            this.topN = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetOverallBucketsRequest build() {
            this._checkSingleUse();
            return new GetOverallBucketsRequest(this);
        }
    }
}

