/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.graph.ExploreControls;
import co.elastic.clients.elasticsearch.graph.ExploreResponse;
import co.elastic.clients.elasticsearch.graph.Hop;
import co.elastic.clients.elasticsearch.graph.VertexDefinition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExploreRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Hop connections;
    @Nullable
    private final ExploreControls controls;
    private final List<String> index;
    @Nullable
    private final Query query;
    @Nullable
    private final String routing;
    @Nullable
    private final Time timeout;
    private final List<String> type;
    private final List<VertexDefinition> vertices;
    public static final JsonpDeserializer<ExploreRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExploreRequest::setupExploreRequestDeserializer);
    public static final Endpoint<ExploreRequest, ExploreResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ExploreRequest, ExploreResponse>("es/graph.explore", request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (ApiTypeHelper.isDefined(request.type())) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_graph");
            buf.append("/explore");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_graph");
            buf.append("/explore");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ExploreResponse._DESERIALIZER);

    private ExploreRequest(Builder builder) {
        this.connections = builder.connections;
        this.controls = builder.controls;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.query = builder.query;
        this.routing = builder.routing;
        this.timeout = builder.timeout;
        this.type = ApiTypeHelper.unmodifiable(builder.type);
        this.vertices = ApiTypeHelper.unmodifiable(builder.vertices);
    }

    public static ExploreRequest of(Function<Builder, ObjectBuilder<ExploreRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Hop connections() {
        return this.connections;
    }

    @Nullable
    public final ExploreControls controls() {
        return this.controls;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final List<String> type() {
        return this.type;
    }

    public final List<VertexDefinition> vertices() {
        return this.vertices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.connections != null) {
            generator.writeKey("connections");
            this.connections.serialize(generator, mapper);
        }
        if (this.controls != null) {
            generator.writeKey("controls");
            this.controls.serialize(generator, mapper);
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.vertices)) {
            generator.writeKey("vertices");
            generator.writeStartArray();
            for (VertexDefinition item0 : this.vertices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupExploreRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connections, Hop._DESERIALIZER, "connections");
        op.add(Builder::controls, ExploreControls._DESERIALIZER, "controls");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::vertices, JsonpDeserializer.arrayDeserializer(VertexDefinition._DESERIALIZER), "vertices");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ExploreRequest> {
        @Nullable
        private Hop connections;
        @Nullable
        private ExploreControls controls;
        private List<String> index;
        @Nullable
        private Query query;
        @Nullable
        private String routing;
        @Nullable
        private Time timeout;
        @Nullable
        private List<String> type;
        @Nullable
        private List<VertexDefinition> vertices;

        public final Builder connections(@Nullable Hop value) {
            this.connections = value;
            return this;
        }

        public final Builder connections(Function<Hop.Builder, ObjectBuilder<Hop>> fn) {
            return this.connections(fn.apply(new Hop.Builder()).build());
        }

        public final Builder controls(@Nullable ExploreControls value) {
            this.controls = value;
            return this;
        }

        public final Builder controls(Function<ExploreControls.Builder, ObjectBuilder<ExploreControls>> fn) {
            return this.controls(fn.apply(new ExploreControls.Builder()).build());
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder type(List<String> list) {
            this.type = Builder._listAddAll(this.type, list);
            return this;
        }

        public final Builder type(String value, String ... values) {
            this.type = Builder._listAdd(this.type, value, values);
            return this;
        }

        public final Builder vertices(List<VertexDefinition> list) {
            this.vertices = Builder._listAddAll(this.vertices, list);
            return this;
        }

        public final Builder vertices(VertexDefinition value, VertexDefinition ... values) {
            this.vertices = Builder._listAdd(this.vertices, value, values);
            return this;
        }

        public final Builder vertices(Function<VertexDefinition.Builder, ObjectBuilder<VertexDefinition>> fn) {
            return this.vertices(fn.apply(new VertexDefinition.Builder()).build(), new VertexDefinition[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExploreRequest build() {
            this._checkSingleUse();
            return new ExploreRequest(this);
        }
    }
}

