/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.IndicesResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class IndicesRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final HealthStatus health;
    @Nullable
    private final Boolean includeUnloadedSegments;
    private final List<String> index;
    @Nullable
    private final Boolean pri;
    public static final Endpoint<IndicesRequest, IndicesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<IndicesRequest, IndicesResponse>("es/cat.indices", request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/indices");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/indices");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (request.pri != null) {
            params.put("pri", String.valueOf(request.pri));
        }
        if (request.health != null) {
            params.put("health", request.health.jsonValue());
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, IndicesResponse._DESERIALIZER);

    private IndicesRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.health = builder.health;
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.pri = builder.pri;
    }

    public static IndicesRequest of(Function<Builder, ObjectBuilder<IndicesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final HealthStatus health() {
        return this.health;
    }

    @Nullable
    public final Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Boolean pri() {
        return this.pri;
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IndicesRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private HealthStatus health;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean pri;

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder health(@Nullable HealthStatus value) {
            this.health = value;
            return this;
        }

        public final Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder pri(@Nullable Boolean value) {
            this.pri = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndicesRequest build() {
            this._checkSingleUse();
            return new IndicesRequest(this);
        }
    }
}

