/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PutTrainedModelAliasResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class PutTrainedModelAliasRequest
extends RequestBase {
    private final String modelAlias;
    private final String modelId;
    @Nullable
    private final Boolean reassign;
    public static final Endpoint<PutTrainedModelAliasRequest, PutTrainedModelAliasResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutTrainedModelAliasRequest, PutTrainedModelAliasResponse>("es/ml.put_trained_model_alias", request -> "PUT", request -> {
        boolean _modelAlias = true;
        int _modelId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/model_aliases");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelAlias, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.reassign != null) {
            params.put("reassign", String.valueOf(request.reassign));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, PutTrainedModelAliasResponse._DESERIALIZER);

    private PutTrainedModelAliasRequest(Builder builder) {
        this.modelAlias = ApiTypeHelper.requireNonNull(builder.modelAlias, this, "modelAlias");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.reassign = builder.reassign;
    }

    public static PutTrainedModelAliasRequest of(Function<Builder, ObjectBuilder<PutTrainedModelAliasRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelAlias() {
        return this.modelAlias;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Boolean reassign() {
        return this.reassign;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutTrainedModelAliasRequest> {
        private String modelAlias;
        private String modelId;
        @Nullable
        private Boolean reassign;

        public final Builder modelAlias(String value) {
            this.modelAlias = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder reassign(@Nullable Boolean value) {
            this.reassign = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutTrainedModelAliasRequest build() {
            this._checkSingleUse();
            return new PutTrainedModelAliasRequest(this);
        }
    }
}

