/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AggregationBase
implements JsonpSerializable {
    private final Map<String, JsonData> meta;
    @Nullable
    private final String name;

    protected AggregationBase(AbstractBuilder<?> builder) {
        this.meta = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).meta);
        this.name = ((AbstractBuilder)builder).name;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAggregationBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "meta");
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private String name;

        protected AbstractBuilder() {
        }

        public final BuilderT meta(Map<String, JsonData> map) {
            this.meta = AbstractBuilder._mapPutAll(this.meta, map);
            return (BuilderT)this.self();
        }

        public final BuilderT meta(String key, JsonData value) {
            this.meta = AbstractBuilder._mapPut(this.meta, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT name(@Nullable String value) {
            this.name = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

