/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.ConditionVariant;
import co.elastic.clients.elasticsearch.watcher.Quantifier;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ArrayCompareCondition
implements ConditionVariant,
JsonpSerializable {
    private final String arrayPath;
    private final String comparison;
    private final String path;
    private final Quantifier quantifier;
    private final JsonData value;
    public static final JsonpDeserializer<ArrayCompareCondition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ArrayCompareCondition::setupArrayCompareConditionDeserializer);

    private ArrayCompareCondition(Builder builder) {
        this.arrayPath = ApiTypeHelper.requireNonNull(builder.arrayPath, this, "arrayPath");
        this.comparison = ApiTypeHelper.requireNonNull(builder.comparison, this, "comparison");
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
        this.quantifier = ApiTypeHelper.requireNonNull(builder.quantifier, this, "quantifier");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static ArrayCompareCondition of(Function<Builder, ObjectBuilder<ArrayCompareCondition>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Condition.Kind _conditionKind() {
        return Condition.Kind.ArrayCompare;
    }

    public final String arrayPath() {
        return this.arrayPath;
    }

    public final String comparison() {
        return this.comparison;
    }

    public final String path() {
        return this.path;
    }

    public final Quantifier quantifier() {
        return this.quantifier;
    }

    public final JsonData value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("array_path");
        generator.write(this.arrayPath);
        generator.writeKey("comparison");
        generator.write(this.comparison);
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("quantifier");
        this.quantifier.serialize(generator, mapper);
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
    }

    protected static void setupArrayCompareConditionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::arrayPath, JsonpDeserializer.stringDeserializer(), "array_path");
        op.add(Builder::comparison, JsonpDeserializer.stringDeserializer(), "comparison");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::quantifier, Quantifier._DESERIALIZER, "quantifier");
        op.add(Builder::value, JsonData._DESERIALIZER, "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ArrayCompareCondition> {
        private String arrayPath;
        private String comparison;
        private String path;
        private Quantifier quantifier;
        private JsonData value;

        public final Builder arrayPath(String value) {
            this.arrayPath = value;
            return this;
        }

        public final Builder comparison(String value) {
            this.comparison = value;
            return this;
        }

        public final Builder path(String value) {
            this.path = value;
            return this;
        }

        public final Builder quantifier(Quantifier value) {
            this.quantifier = value;
            return this;
        }

        public final Builder value(JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ArrayCompareCondition build() {
            this._checkSingleUse();
            return new ArrayCompareCondition(this);
        }
    }
}

